import type { Dispatch, SetStateAction } from 'react';

export type TStatus = 'idle' | 'ready' | 'error' | 'payment-error' | 'payment-pending' | 'payment-cancelled' | 'payment-paid';

export type TComgateCheckoutConstructParameters = {
    setApplePayModuleId: Dispatch<SetStateAction<string | null>>;
    setGooglePayModuleId: Dispatch<SetStateAction<string | null>>;
};

export type TUseComgateCheckoutParams = {
    applePayButtonBoxRef: React.RefObject<HTMLDivElement | null>;
    googlePayButtonBoxRef: React.RefObject<HTMLDivElement | null>;
    paymentId: string;
};
