import {
    preloadComgateCheckout as _preloadComgateCheckout,
    loadComgateCheckout as _loadComgateCheckout,
    VERSION_2,
    type TLoadComgateCheckoutResult,
} from '@comgate/checkout-js';
import { CHECKOUT_ID, CHECKOUT_MODULES, CHECKOUT_DEBUG } from './configuration';

/**
 * Preloads the Comgate checkout module with provided configurations.
 * If the loading process fails, the error will be logged in the console.
 */
export function preloadComgateCheckout() {
    _preloadComgateCheckout({
        checkoutId: CHECKOUT_ID,
        version: VERSION_2,
        modules: CHECKOUT_MODULES,
    }).catch((error: unknown) => {
        console.error('Comgate Checkout: Preload failed:', error);
    });
}

/**
 * Loads the Comgate checkout with provided configurations.
 * If an error occurs during the process, it throws the encountered error.
 *
 * If called during the preload process, the preload is stopped and the execution continues from its current state.
 *
 * @return {Promise<TLoadComgateCheckoutResult>} A promise that resolves with the result of the Comgate checkout load operation or throws an error if the operation fails.
 */
export async function loadComgateCheckout(): Promise<TLoadComgateCheckoutResult> {
    const result = await _loadComgateCheckout({
        checkoutId: CHECKOUT_ID,
        version: VERSION_2,
        modules: CHECKOUT_MODULES,
        debug: CHECKOUT_DEBUG,
    }).catch((error: unknown) => {
        return { error: error };
    });

    if (result?.error) {
        throw result.error;
    }

    return result;
}
