// import {type RefObject, useEffect, useRef, useState} from 'react'
import PayButtonsContainer from './components/PayButtonsContainer';
import { preloadComgateCheckout } from './shared/comgate/checkout';
import { useEffect, useState } from 'react';

function App() {
    const [swap, setSwap] = useState<boolean>(true);
    const [show, setShow] = useState<boolean>(false);
    const [final, setFinal] = useState<boolean>(false);
    // In a real project, the transactionId will be loaded into the application dynamically – for this example, a fixed value is used
    const [paymentId] = useState('XXXX-XXXX-XXXX');
    // const [testSwitchPayment] = useState('YYYY-YYYY-YYYY');

    // Checkout preload
    useEffect(() => {
        preloadComgateCheckout();
    }, []);

    // DIY: other code

    return (
        <div>
            {swap && (
                <div>
                    <PayButtonsContainer
                        paymentId={paymentId}
                        onFinal={() => setFinal(true)}
                    />
                </div>
            )}
            {!swap && (
                <div>
                    <PayButtonsContainer
                        paymentId={paymentId}
                        onFinal={() => setFinal(true)}
                    />
                </div>
            )}

            {!final && (
                <button
                    onClick={() => {
                        setSwap(!swap);
                    }}
                >
                    Swap instance (simulate component creation and destruction)
                </button>
            )}

            {!final && <hr />}

            {!final &&
                (show ? (
                    <PayButtonsContainer
                        paymentId={paymentId}
                        onFinal={() => setFinal(true)}
                    />
                ) : (
                    <>
                        <br />
                        <button onClick={() => setShow(true)}>Show duplicate instance</button>
                    </>
                ))}

            {/* change payment ID test */}
            {/*{paymentId !== testSwitchPayment && (*/}
            {/*    <button*/}
            {/*        onClick={() => {*/}
            {/*            setPaymentId(testSwitchPayment);*/}
            {/*        }}*/}
            {/*    >*/}
            {/*        Change payment {paymentId} to {testSwitchPayment}*/}
            {/*    </button>*/}
            {/*)}*/}
        </div>
    );
}

export default App;
