import { type ModuleGooglePay } from '@comgate/checkout-js'

export const useMountGooglePayInstance = async (
  googlePayInstance: ModuleGooglePay,
  elementId: string,
) => {
  try {
    await googlePayInstance.canMakePayments()
    const gpMountElement = document.querySelector(`#${elementId}`)
    if (gpMountElement) {
      try {
        await googlePayInstance.mount([gpMountElement])
      } catch (error) {
        console.error('Nepodařilo se namountovat element: ', error)
      }
    } else {
      console.error('Nepodařilo se najít vstupní bod pro mount.')
    }
  } catch (error) {
    console.error('Nepodařilo se inicializovat Google Pay:" ', error)
  }
}
