import { type ModuleApplePay } from '@comgate/checkout-js'

export const useMountApplePayInstance = async (
  applePayInstance: ModuleApplePay,
  elementId: string,
) => {
  try {
    await applePayInstance.canMakePayments()
    const apMountElement = document.querySelector(`#${elementId}`)
    if (apMountElement) {
      try {
        await applePayInstance.mount([apMountElement])
      } catch (error) {
        console.error('Nepodařilo se namountovat element: ', error)
      }
    } else {
      console.error('Nepodařilo se najít vstupní bod pro mount.')
    }
  } catch (error) {
    console.error('Nepodařilo se inicializovat Apple Pay: ', error)
  }
}
