import {
  type TCheckoutOnPaidParams,
  type TLoadComgateCheckoutResult,
  type TCheckoutOnCancelledParams,
  type TCheckoutOnPendingParams,
  type TCheckoutOnErrorParams,
} from '@comgate/checkout-js'

import { errorToast, successToast, cancelledToast, pendingToast } from '../components/Toast'

export const useInitCheckout = async (
  response: TLoadComgateCheckoutResult,
  transactionId: string,
): Promise<TLoadComgateCheckoutResult> =>
  response.core.create({
    checkoutId: import.meta.env.VITE_COMGATE_CHECKOUT_ID,
    transactionId,
    env: 'dev',
    locale: 'cs',
    onPaid: ({ status }: TCheckoutOnPaidParams) => successToast(status),
    onCancelled: ({ message }: TCheckoutOnCancelledParams) =>
      cancelledToast(`Platba byla zrušena: ${message}`),
    onPending: ({ message }: TCheckoutOnPendingParams) => pendingToast(message),
    onError: ({ error }: TCheckoutOnErrorParams) => {
      ;(console.error(error), errorToast(error))
    },
    debug: true,
  })
