import {
  type CheckoutCore,
  type TLoadComgateCheckoutResult,
  type ModuleGooglePay,
} from '@comgate/checkout-js'

export const useCreateGooglePayInstance = async (
  response: TLoadComgateCheckoutResult,
  coreInstance: CheckoutCore,
): Promise<ModuleGooglePay> => {
  try {
    return await response.googlepay.create(coreInstance, {
      ui: {
        color: 'black',
        type: 'short',
      },
    })
  } catch (error) {
    console.error('Nepodařilo se inicializovat Google Pay instanci: ', error)
  }
}
