import {
  type CheckoutCore,
  type ModuleApplePay,
  type TLoadComgateCheckoutResult,
} from '@comgate/checkout-js'

export const useCreateApplePayInstance = async (
  response: TLoadComgateCheckoutResult,
  coreInstance: CheckoutCore,
): Promise<ModuleApplePay> => {
  try {
    return await response.applepay.create(coreInstance, {
      ui: {
        color: 'black',
        type: 'plain',
      },
    })
  } catch (error) {
    console.error('Nepodařilo se inicializovat Apple Pay instanci: ', error)
  }
}
