import Toast from 'typescript-toastify'

const showToast = (type: 'error' | 'success' | 'info' | 'warning', toastMsg: string) =>
  new Toast({
    type,
    toastMsg,
    position: 'top-center',
    autoCloseTime: 4500,
    canClose: true,
    showProgress: true,
    pauseOnHover: true,
    pauseOnFocusLoss: true,
    theme: 'light',
  })

export const errorToast = (message: string) => showToast('error', message)

export const successToast = (status: string) =>
  showToast('success', `Platba proběhla úspěšně! Status ${status}`)

export const cancelledToast = (message: string) =>
  showToast('warning', `Platba byla zrušená: ${message}`)

export const pendingToast = (message: string) => showToast('info', message)
