package cn.nexgo.inbas.transactions.sale.internal;

import android.text.TextUtils;

import com.nexgo.common.ByteUtils;
import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.emv.EmvOnlineResultEntity;
import com.nexgo.oaf.apiv3.emv.EmvProcessFlowEnum;
import com.nexgo.oaf.apiv3.emv.EmvTransFlowEnum;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.TimeUnit;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.base.BaseFragmentActivity;
import cn.nexgo.inbas.common.bean.AmountBean;
import cn.nexgo.inbas.common.bean.ErrorCode;
import cn.nexgo.inbas.common.widget.ContinuePrintDialog;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.emv.EmvBaseActivity;
import cn.nexgo.inbas.components.emv.IEmvCore;
import cn.nexgo.inbas.components.emv.bean.AppEmvOnlineResultEntity;
import cn.nexgo.inbas.components.emv.bean.CardInfo;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.emv.bean.EmvOnlineResultState;
import cn.nexgo.inbas.components.emv.bean.EmvTransState;
import cn.nexgo.inbas.components.input.amount.InputAmountData;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;
import cn.nexgo.inbas.components.others.print.Printer;
import cn.nexgo.inbas.controller.global.TransType;
import cn.nexgo.inbas.transactions.common.commontrans.CommonTransExtransListener;
import cn.nexgo.inbas.transactions.common.commontrans.ExtraTrans;
import cn.nexgo.inbas.transactions.common.misc.CommonPrint;
import cn.nexgo.inbas.transactions.common.protocol.MsgModel;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;
import cn.nexgo.utils.AppTlvUtils;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ConvertUtils;
import cn.nexgo.utils.ToastUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/21
 * Modify          : create file
 **************************************************************************************************/
public class SalePresenter implements SaleContract.IPresenter {
    private Logger log = LoggerFactory.getLogger(SalePresenter.class.getSimpleName());

    private SaleContract.IView view;
    private EmvCardControlEntity emvCardControlEntity = new EmvCardControlEntity();
    private SaleEntity dataEntity;
    private IEmvCore emvCore;
    private GData gData = GData.getInstance();

    private DataOpenHelper dataOpenHelper = DataOpenHelper.getInstance();

    public SalePresenter(SaleContract.IView view, IEmvCore emvCore) {
        this.view = view;
        this.emvCore = emvCore;
    }

    @Override
    public void startProcess() {
        needOnlineRequest = false;
//        Observable.create(new ObservableOnSubscribe<Object>() {
//            @Override
//            public void subscribe(ObservableEmitter<Object> e) throws Exception {
//                dataEntity = new SaleEntity();
//            }
//        })
//                .subscribeOn(Schedulers.newThread())
//                .subscribe();
        dataEntity = new SaleEntity();
        MsgModel.setCommonRequestData(dataEntity);
        // step 1: input amount
        InputAmountData inputAmountData = new InputAmountData(gData.getSetupEntity().getTermAmountDecimalLen(),
                gData.getSetupEntity().getTermCurrencyName());

        log.debug("SaleActivity onRequestInputAmount");
        view.onRequestInputAmount(inputAmountData, inputAmountCallBack);
    }

    private InputAmountCallBack inputAmountCallBack = new InputAmountCallBack() {
        @Override
        public void onAmount(AmountBean amount) {
            dataEntity.getTransRecordEntity().setMsgAmount(String.valueOf(amount.getLongValue()));
            emvCardControlEntity.setTransAmount(String.valueOf(amount.getLongValue()));
            startCardProcess();
        }

        @Override
        public void onCancel() {
            view.finishActivity();
        }

        @Override
        public void onTimeOut() {
            view.finishActivity();
        }
    };

    // step 2: start card process
    private void startCardProcess() {
        // emv params
        emvCardControlEntity.setSupportMag(true);
        emvCardControlEntity.setSupportCTLS(gData.getSetupEntity().getTransCTLS());
        emvCardControlEntity.setSupportICC(true);
        emvCardControlEntity.setSupportManual(false);
        emvCardControlEntity.setConfirmPan(true);
        emvCardControlEntity.setPinKeyIndex(gData.getSetupEntity().getSafeTmkIndex());
        emvCardControlEntity.setNeedPin(true);
        emvCardControlEntity.setTraceNo(gData.getSetupEntity().getTransTraceNO());
        emvCardControlEntity.setTermId(gData.getSetupEntity().getTermTID());
        emvCardControlEntity.setMerchantId(gData.getSetupEntity().getTermMID());

        emvCardControlEntity.setTransType(TransType.SALE);//mike_zj
        emvCardControlEntity.setForceOnline(gData.getSetupEntity().getTransForceOnline());
        emvCardControlEntity.setCashbackAmount("0");
        emvCardControlEntity.setSupportFallback(gData.getSetupEntity().getTransFallback());

        log.debug("startCardProcess->");
        view.startCardProcess(emvCardControlEntity, emvBaseCallback);
    }

    private EmvBaseActivity.EmvBaseCallback emvBaseCallback = new EmvBaseActivity.EmvBaseCallback() {
        // FIXME: 2020/5/11
        @Override
        public EmvProcessFlowEnum getEmvTransFlowEnum(CardType cardType) {

            return EmvProcessFlowEnum.EMV_PROCESS_FLOW_STANDARD;
        }


        @Override
        public void onProcessMagCard(CardInfo cardInfo) {
            magCardTrans(cardInfo);
        }

        @Override
        public void onProcessManualCard(CardInfo cardInfo) {
            log.debug("onProcessManualCard-> {}", cardInfo.getPan());
        }

        @Override
        public void onEmvSimpleFlow(CardInfo cardInfo) {
            log.debug("onEmvSimpleFlow");
        }

        @Override
        public void onEmvMsdFlow(CardInfo cardInfo) {
            log.debug("onEmvMsdFlow");
            MSDOnline(cardInfo);
        }

        @Override
        public void onEmvQpbocOnlineProcess() {
            log.debug("onEmvQpbocOnlineProcess");
            qPbocTrans();
        }

        @Override
        public void onEmvRequestOnlineProcess() {
            log.debug("onEmvRequestOnlineProcess");
            emvOnline();
        }

        @Override
        public void onFinish(EmvTransState transState, String description) {
            log.debug("onFinish");
            processEmvResult(transState, description);
        }
    };

    private void setCardInfo() {
        log.debug("PIN-> {}", ConvertUtils.bytes2HexString(emvCore.getEmvTransData().getPinBlock()));
        dataEntity.setPIN(ConvertUtils.bytes2HexString(emvCore.getEmvTransData().getPinBlock()));
        dataEntity.getTransRecordEntity().setEmvPanSN(emvCore.getEmvTransData().getCsn());
        dataEntity.getTransRecordEntity().setCardNoEnc(emvCore.getEmvTransData().getPan());
        dataEntity.getTransRecordEntity().setCardExpDateEnc(emvCore.getEmvTransData().getExpDate());
        dataEntity.setTk2(emvCore.getEmvTransData().getTk2());
    }

    private void processEmvResult(EmvTransState transState, String description) {
        log.debug("finish-> {}", transState.name());
        switch (transState) {
            case EMV_ONLINE_APPROVE:
                dataEntity.setField55(emvCore.getEmvRecordTLV());//modify by hassan
                String resultScrip = emvCore.getEmvScriptTLV(); // get result script
                if (resultScrip != null) {
                    dataEntity.getTransRecordEntity().setStatusNeedScript(true);
                }
                dataEntity.getTransRecordEntity().setStatusNeedReversal(false);
                dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());
                printReceipt();
                break;

            case EMV_ERR_ONLINE_DECLINED_REVERSAL:
                dataEntity.getTransRecordEntity().setStatusNeedReversal(true);
                dataEntity.getTransRecordEntity().setStatusReversalReason(DataConstant.ReversalReason.AUTH_FAIL);
                dataEntity.getTransRecordEntity().setStatusIccFailTrans(true);
                dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());
                needOnlineRequest = false;
                doReversal(BaseUtils.getApp().getString(R.string.trans_carddeclined));
                break;

            case EMV_OFFLINE_APPROVE:
                MsgModel.incTransNo();
                //Modified by Brad2018/4/10 -add
                log.debug("EMV_OFFLINE_APPROVE");
                dataEntity.setField55(emvCore.getEmvRecordTLV());
                dataEntity.getTransRecordEntity().setCardType(emvCore.getEmvTransData().getCardType());
                dataEntity.getTransRecordEntity().setCardExpDateEnc(emvCore.getEmvTransData().getExpDate());
                dataEntity.getTransRecordEntity().setCardNoEnc(emvCore.getEmvTransData().getPan());
                dataEntity.getTransRecordEntity().setEmvPanSN(emvCore.getEmvTransData().getCsn());
                //end Brad

                dataEntity.getTransRecordEntity().setStatusOffline(true);
                dataOpenHelper.getTransRecordRepository().insert(dataEntity.getTransRecordEntity());
                printReceipt();
                break;

            case EMV_ERR_OFFLINE_DECLINED:
                MsgModel.incTransNo();
                //Modified by Brad2018/4/10 -add
                dataEntity.setField55(emvCore.getEmvRecordTLV());
                dataEntity.getTransRecordEntity().setCardType(emvCore.getEmvTransData().getCardType());
                dataEntity.getTransRecordEntity().setCardExpDateEnc(emvCore.getEmvTransData().getExpDate());
                dataEntity.getTransRecordEntity().setCardNoEnc(emvCore.getEmvTransData().getPan());
                dataEntity.getTransRecordEntity().setEmvPanSN(emvCore.getEmvTransData().getCsn());
                //end Brad
                dataEntity.getTransRecordEntity().setStatusIccFailTrans(true);
                dataEntity.getTransRecordEntity().setStatusOffline(true);
                dataOpenHelper.getTransRecordRepository().insert(dataEntity.getTransRecordEntity());
                if (needOnlineRequest) {
                    view.transFail(BaseUtils.getApp().getString(R.string.trans_connectfail), dataEntity.getTransRecordEntity());
                } else {
                    view.transFail(description, dataEntity.getTransRecordEntity());
                }
                break;

            case EMV_ERR_ONLINE_DECLINED_RESPONSE:
                dataOpenHelper.getTransRecordRepository().delete(dataEntity.getTransRecordEntity());
                view.transFail(BaseUtils.getApp().getString(R.string.transresult_responsecodeerror) +
                                dataEntity.getTransRecordEntity().getMsgRespCode(),
                        dataEntity.getTransRecordEntity());
                break;

            default:
                view.transFail(description, dataEntity.getTransRecordEntity());
                break;
        }
    }

    // step 3.1: mag card trans
    private void magCardTrans(CardInfo cardInfo) {
        dataEntity.getTransRecordEntity().setCardType(CardType.MAG);
        dataEntity.setTk2(cardInfo.getTk2());
        dataEntity.setTk3(cardInfo.getTk3());
        dataEntity.getTransRecordEntity().setCardNoEnc(cardInfo.getPan());
        dataEntity.getTransRecordEntity().setCardExpDateEnc(cardInfo.getExpiredDate());
        dataEntity.setPIN(ConvertUtils.bytes2HexString(cardInfo.getPinBlock()));
        dataEntity.getTransRecordEntity().setCardFallback(cardInfo.isFallback());

        hostTrans();
    }

    // step 3.2：qpboc card trans
    private void qPbocTrans() {
        dataEntity.getTransRecordEntity().setCardType(CardType.CTLS);
        dataEntity.setField55(emvCore.getEmvRecordTLV());
        dataEntity.setEmv55FieldDOLType(emvCore.getEmvTransData().getEmv55FieldDOLType());
        setCardInfo();

        hostTrans();
    }

    // step 3.3: ICC card trans
    private boolean needOnlineRequest = false;  // second auth flag

    private void emvOnline() {
        view.showDialog(true, BaseUtils.getApp().getString(R.string.wait),
                BaseUtils.getApp().getString(R.string.trans_online));

        dataEntity.getTransRecordEntity().setCardType(emvCore.getEmvTransData().getCardType());

        setCardInfo();
        dataEntity.setField55(emvCore.getEmvRecordTLV());
        dataEntity.setEmv55FieldDOLType(emvCore.getEmvTransData().getEmv55FieldDOLType());

        needOnlineRequest = true;

        hostTrans();
    }

    // step 3.4:MSD
    private void MSDOnline(CardInfo cardInfo) {
        needOnlineRequest = true;
        dataEntity.getTransRecordEntity().setCardCtlsFlowType(DataConstant.CtlsFlowType.MSD);
        dataEntity.getTransRecordEntity().setCardType(CardType.CTLS);
        dataEntity.setTk2(cardInfo.getTk2());
        dataEntity.getTransRecordEntity().setCardNoEnc(cardInfo.getPan());
        dataEntity.getTransRecordEntity().setCardExpDateEnc(cardInfo.getExpiredDate());
        dataEntity.setPIN(ConvertUtils.bytes2HexString(cardInfo.getPinBlock()));

        hostTrans();
    }

    // host communication
    private void hostTrans() {
        view.showDialog(true, BaseUtils.getApp().getString(R.string.wait), BaseUtils.getApp().getString(R.string.trans_pretrans));
        new ExtraTrans().start(true,
                true, true, commonTransExtransListener);//modify ba hassan
    }

    private CommonTransExtransListener commonTransExtransListener = new CommonTransExtransListener() {
        @Override
        public void onSuccess() {
            view.showDialog(true, BaseUtils.getApp().getString(R.string.wait), BaseUtils.getApp().getString(R.string.trans_online));
            MsgModel.setCommonRequestData(dataEntity);
            MsgModel.trans(dataEntity, new SaleEntity(), true, true, false, hostTransListener);
        }

        @Override
        public void onFail(ErrorCode errorCode) {
            view.transFail(BaseUtils.getApp().getString(R.string.trans_pretransfail), dataEntity.getTransRecordEntity());
            if (needOnlineRequest) {
                emvCore.EmvResponseOnlineProcess(EmvOnlineResultState.EMV_CONNECT_ERR, null);
            }
        }

        @Override
        public void onError(ErrorCode errorCode) {

        }
    };

    private MsgModel.ModelListener hostTransListener = new MsgModel.ModelListener() {
        @Override
        public void onConnectError(ErrorCode errorCode) {
            log.error("onConnectError->" + errorCode.getMsg());

            if (dataEntity.getTransRecordEntity().getCardTypeEnum() == CardType.MAG) {
                view.transFail(BaseUtils.getApp().getString(R.string.trans_connectfail), dataEntity.getTransRecordEntity());
                return;
            }

            if (dataEntity.getTransRecordEntity().getCardTypeEnum() == CardType.CTLS) {
                view.transFail(BaseUtils.getApp().getString(R.string.trans_connectfail), dataEntity.getTransRecordEntity());
                emvCore.EmvResponseOnlineProcess(EmvOnlineResultState.EMV_CONNECT_ERR, null);
                return;
            }

            emvCore.EmvResponseOnlineProcess(EmvOnlineResultState.EMV_CONNECT_ERR_SWITCH_OFFLINE, null);
        }

        @Override
        public void onConnectSuccess() {
            dataEntity.getTransRecordEntity().setStatusNeedReversal(true);
            dataEntity.getTransRecordEntity().setStatusReversalReason(DataConstant.ReversalReason.OTHER);//modify by hassan
            dataOpenHelper.getTransRecordRepository().insert(dataEntity.getTransRecordEntity());
        }

        @Override
        public void onSendError(ErrorCode errorCode) {
            log.error("onSendError->" + errorCode.getMsg());
            doReversal(BaseUtils.getApp().getString(R.string.trans_sendfail));
        }

        @Override
        public void onSendSuccess() {

        }

        @Override
        public void onReceiveError(ErrorCode errorCode) {
            log.error("onReceiveError->" + errorCode.getMsg() + ", code->" + errorCode.getCode());

            if (errorCode.getCode() == MsgModel.MACError.getCode()) {
                dataEntity.getTransRecordEntity().setStatusReversalReason(DataConstant.ReversalReason.MAC_ERR);
                dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());
                doReversal(BaseUtils.getApp().getString(R.string.trans_receivefail) + "->mac error");
            } else if (errorCode.getCode() == MsgModel.ParamsError.getCode()) {//modify by hassan
                // FIXME: 2018/4/12
                dataEntity.getTransRecordEntity().setStatusReversalReason(DataConstant.ReversalReason.OTHER);
                dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());
                doReversal(BaseUtils.getApp().getString(R.string.trans_receivefail));
            } else {
                dataEntity.getTransRecordEntity().setStatusReversalReason(DataConstant.ReversalReason.RECV_TIMEOUT);
                dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());

                doReversal(BaseUtils.getApp().getString(R.string.trans_receivefail));
            }
        }

        @Override
        public void onReceiveSuccess(MsgBean.BaseTransEntity responseBean) {
            dataEntity.copyResponseData(responseBean.getTransRecordEntity()); //  copy data from response data
            dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());

            if (needOnlineRequest) {
                secondAuth(responseBean);
                return;
            }

            dealNormalCardOnlineTransResult(responseBean);
        }

    };

    private void dealNormalCardOnlineTransResult(MsgBean.BaseTransEntity responseBean) {
        log.debug("dealNormalCardOnlineTransResult-> {}", responseBean.getTransRecordEntity().getMsgRespCode());
        if (!"00".equals(responseBean.getTransRecordEntity().getMsgRespCode())) {
            dataOpenHelper.getTransRecordRepository().delete(dataEntity.getTransRecordEntity());
            view.transFail(BaseUtils.getApp().getString(R.string.transresult_responsecodeerror) + responseBean.getTransRecordEntity().getMsgRespCode(), dataEntity.getTransRecordEntity());
            return;
        }

        dataEntity.getTransRecordEntity().setStatusNeedReversal(false);
        dataOpenHelper.getTransRecordRepository().update(dataEntity.getTransRecordEntity());
        printReceipt();
    }
    private String transformEmvResponseCode(String responseCode, String hostField55Data){
        log.debug("transformEmvResponseCode hostField55Data: {}", hostField55Data);
        if(responseCode == null){
            return "05";
        }


        if(hostField55Data == null){
            return responseCode;
        }

        Map<String, String> field55Data = AppTlvUtils.parse(hostField55Data);
        if(field55Data == null){
            return responseCode;
        }

        String tmp = null;
        tmp = field55Data.get("8A");
        if(tmp == null){
            return responseCode;
        }
        tmp = new String(ByteUtils.hexString2ByteArray(tmp));
        log.debug("transformEmvResponseCode tmp: {}", tmp);
        return tmp;
    }
    private void secondAuth(MsgBean.BaseTransEntity responseBean) {
        log.debug("secondAuth");

        AppEmvOnlineResultEntity emvOnlineResultEntity = new AppEmvOnlineResultEntity();
        emvOnlineResultEntity.setAuthCode(responseBean.getTransRecordEntity().getMsgAuthCode());

        // FIXME: 2020/7/16 use 8a to fill the response code
        emvOnlineResultEntity.setRejCode(responseBean.getTransRecordEntity().getMsgRespCode());//39 field response code
        emvOnlineResultEntity.setEmvResponseCode8a(transformEmvResponseCode(responseBean.getTransRecordEntity().getMsgRespCode(),
                responseBean.getField55Response()));//39 field response code

        emvOnlineResultEntity.setRecvField55(ConvertUtils.hexString2Bytes(responseBean.getField55Response()));

        emvCore.EmvResponseOnlineProcess(
                EmvOnlineResultState.EMV_SECOND_AUTH,
                emvOnlineResultEntity);
    }

    // step 4: print receipt
    private void printReceipt() {
        String module = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getDeviceInfo().getModel();
        log.debug("current module : {}", module);
        if (!TextUtils.isEmpty(module) && module.equalsIgnoreCase("N6")) {
            finishPrint();
            return;
        }
        dataEntity.getTransRecordEntity().setStatusNeedPrint(true);  // set printed flag
        DataOpenHelper.getInstance().getTransRecordRepository().update(dataEntity.getTransRecordEntity());
        Observable.create(new ObservableOnSubscribe<Object>() {  // action
            @Override
            public void subscribe(ObservableEmitter<Object> e) throws Exception {
                new CommonPrint((BaseFragmentActivity) view,
                        BaseUtils.getApp().getString(R.string.print_printing), BaseUtils.getApp().getString(R.string.trans_printmerchantreceipt),
                        dataEntity.getTransRecordEntity(), true, false, Printer.CopyType.MERCHANT, printMerchantListener).startPrint();

            }
        })
                .subscribeOn(Schedulers.io())
                .subscribe();
    }

    private CommonPrint.Listener printMerchantListener = new CommonPrint.Listener() {
        @Override
        public void onSuccess() {
            startShowContinuePrintDialog();
        }

        @Override
        public void onCancel() {
            view.showDialog(false, null, null);
            view.transSuccess(dataEntity.getTransRecordEntity());
        }

        @Override
        public void onContinue() {
            printReceipt();
        }
    };

    /**
     * 显示继续打印对话框 show continue print dialog
     */
    private void startShowContinuePrintDialog() {
        if (gData.getSetupEntity().getTransPrintTimes() < 2) {
            finishPrint();
            return;
        }
        view.showContinuePrintDialog(continueListener);
    }

    private ContinuePrintDialog.OnContinueListener continueListener = new ContinuePrintDialog.OnContinueListener() {
        @Override
        public void onConfirm() {
            startPrintCardHolderReceipt();
        }

        @Override
        public void onCancel() {
            finishPrint();
        }
    };

    private void startPrintCardHolderReceipt() {
        Observable.timer(200, TimeUnit.MILLISECONDS)
                .subscribeOn(Schedulers.io())
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(Long aLong) throws Exception {
                        new CommonPrint((BaseFragmentActivity) view,
                                BaseUtils.getApp().getString(R.string.print_printing), BaseUtils.getApp().getString(R.string.trans_printcustomerreceipt),
                                dataEntity.getTransRecordEntity(), true, false, Printer.CopyType.CARDHODLDER, printCardHolderListener).startPrint();
                    }
                });
    }

    private CommonPrint.Listener printCardHolderListener = new CommonPrint.Listener() {
        @Override
        public void onSuccess() {
            finishPrint();
        }

        @Override
        public void onCancel() {
            view.showDialog(false, null, null);
            view.transSuccess(dataEntity.getTransRecordEntity());
        }

        @Override
        public void onContinue() {
            printReceipt();
        }
    };

    private void finishPrint() {
        log.debug("finishPrint");
        dataEntity.getTransRecordEntity().setStatusNeedPrint(false);  // set printed flag
        DataOpenHelper.getInstance().getTransRecordRepository().update(dataEntity.getTransRecordEntity());

        view.showDialog(false, null, null);
        view.transSuccess(dataEntity.getTransRecordEntity());
    }

    // step 5: do reversal
    private String reversalReason;

    private void doReversal(String reason) {
        reversalReason = reason;
        log.error("doReversal->");

        view.showDialog(true, BaseUtils.getApp().getString(R.string.wait),
                BaseUtils.getApp().getString(R.string.trans_reversal));
        new ExtraTrans().start(false, false, false, transAfterExtransListener);
    }

    private CommonTransExtransListener transAfterExtransListener = new CommonTransExtransListener() {

        private void finishEMV() {
            if (dataEntity.getTransRecordEntity().getCardTypeEnum() == CardType.MAG) {
                return;
            }

            if (needOnlineRequest) {
                emvCore.EmvResponseOnlineProcess(EmvOnlineResultState.EMV_CONNECT_ERR, null);
            }
        }

        @Override
        public void onSuccess() {
            view.transFail(reversalReason, dataEntity.getTransRecordEntity());
            MsgModel.disConnect(null);
            log.debug("reversalReason: {}", reversalReason);

            finishEMV();
        }

        @Override
        public void onFail(ErrorCode errorCode) {
            view.transFail(reversalReason, dataEntity.getTransRecordEntity());
            MsgModel.disConnect(null);
            log.debug("reversalReason: {}", reversalReason);

            finishEMV();
        }

        @Override
        public void onError(ErrorCode errorCode) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.trans_reversalfail));
            log.debug("reversalReason: {}", reversalReason);
            view.transFail(reversalReason, dataEntity.getTransRecordEntity());
            MsgModel.disConnect(null);

            finishEMV();
        }
    };

}
