package cn.nexgo.inbas.transactions.sale.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.controller.global.TransType;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;
import cn.nexgo.protocol.iso8583.Message;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/31
 * Modify          : create file
 **************************************************************************************************/
public class SaleEntity extends MsgBean.BaseTransEntity {
    private GData gData = GData.getInstance();
    private Logger mLog = LoggerFactory.getLogger(SaleEntity.class.getSimpleName());

    SaleEntity() {
        getTransRecordEntity().setTransType(TransType.SALE);

        setMsgType("0200");
        getTransRecordEntity().setMsgProcCode("000000");
        getTransRecordEntity().setMsgConditionCode("00");
        getTransRecordEntity().setMsgPinCapCode("12");
        getTransRecordEntity().setMsgFuncCode("22");
    }

    @Override
    public byte[] packageMsg() {
        Message msg;

        msg = super.setCommonDataIntoMsg("702406C030C09A01"); //modify by hassan, add field 26
        if (msg == null) {
            mLog.error("set commonData error");
            return null;
        }

        //field 60
        StringBuilder sb = new StringBuilder();
        //60.1
        sb.append(getTransRecordEntity().getMsgFuncCode());
        //60.2
        sb.append(FormatUtils.appendArray(getTransRecordEntity().getMsgBatchNO(), 6, true, '0'));
        //60.3
        sb.append("000");

        //60.4
        CardType cardType = getTransRecordEntity().getCardTypeEnum();
        if (cardType == CardType.MANUAL
                || cardType == CardType.ICC
                || cardType == CardType.MAG) {
            sb.append("5");
        } else if (cardType == CardType.CTLS) {
            sb.append("6");
        } else {
            sb.append("0");
        }

        //60.5
        if (getTransRecordEntity().getCardFallback() && cardType == CardType.MAG) {
            sb.append("2");
        } else {
            sb.append("0");
        }
        //60.6
        sb.append("0");
        msg.setFieldValue(60, sb.toString());

        return msg.formMsg(2, gData.getSetupEntity().getCommuMsgLenTypeEnum());
    }
}