package cn.nexgo.inbas.transactions.sale.internal;

import cn.nexgo.inbas.common.base.ConfirmAndCancelListener;
import cn.nexgo.inbas.common.widget.ContinuePrintDialog;
import cn.nexgo.inbas.components.data.bean.TransRecordEntity;
import cn.nexgo.inbas.components.emv.EmvBaseActivity;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.input.amount.InputAmountData;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/21
 * Modify          : create file
 **************************************************************************************************/
public class SaleContract {
    public interface IPresenter{
        void startProcess();
    }

    public interface IView{
        void onRequestInputAmount(InputAmountData inputAmountData, InputAmountCallBack inputAmountCallBack);
        void startCardProcess(EmvCardControlEntity emvCardControlEntity, EmvBaseActivity.EmvBaseCallback callback);

        void finishActivity();

        void transSuccess(TransRecordEntity transRecordEntity);

        void transFail(String errorMsg, TransRecordEntity transRecordEntity);

        void showDialog(boolean enable, String title, String msg);

        void confirmDialog(String title, String msg, String cancelBtnStr, String confirmBtnStr, ConfirmAndCancelListener listener);

        void showContinuePrintDialog(ContinuePrintDialog.OnContinueListener onContinueListener);
    }
}
