package cn.nexgo.inbas.transactions.sale;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.Nullable;
import android.view.KeyEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.ConfirmAndCancelListener;
import cn.nexgo.inbas.common.widget.ContinuePrintDialog;
import cn.nexgo.inbas.components.data.bean.TransRecordEntity;
import cn.nexgo.inbas.components.emv.EmvBaseActivity;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.input.amount.InputAmountData;
import cn.nexgo.inbas.components.input.amount.InputAmountFragment;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;
import cn.nexgo.inbas.transactions.common.view.result.CommonResultFragment;
import cn.nexgo.inbas.transactions.common.view.result.ResultBean;
import cn.nexgo.inbas.transactions.sale.internal.SaleContract;
import cn.nexgo.inbas.transactions.sale.internal.SalePresenter;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ToastUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/20
 * Modify          : create file
 **************************************************************************************************/
public class SaleActivity extends EmvBaseActivity implements SaleContract.IView, InputAmountFragment.OnInputAmountCallBack {
    private Logger log = LoggerFactory.getLogger(SaleActivity.class.getSimpleName());
    private Handler handler = new Handler(Looper.getMainLooper());

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        startLogic();
    }

    private void startLogic() {
        SaleContract.IPresenter presenter = new SalePresenter(SaleActivity.this, getEmvCore());
        presenter.startProcess();
//        Observable.create(new ObservableOnSubscribe<Object>() {
//            @Override
//            public void subscribe(ObservableEmitter<Object> e) throws Exception {
//                presenter = new SalePresenter(SaleActivity.this, getEmvCore());
//                presenter.startProcess();
//            }
//        })
//                .subscribeOn(Schedulers.newThread())
//                .subscribe();
    }

    @Override
    protected int getContextViewId() {
        return R.id.fl_container;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.common_container;
    }

    //***********************************************************
    private InputAmountCallBack inputAmountCallBack;

    @Override
    public void onRequestInputAmount(InputAmountData inputAmountData, InputAmountCallBack inputAmountCallBack) {
        this.inputAmountCallBack = inputAmountCallBack;
        startFragment(InputAmountFragment.newInstance(BaseUtils.getApp().getString(R.string.home_sale), inputAmountData, this), false);
    }

    @Override
    public void startCardProcess(EmvCardControlEntity emvCardControlEntity, EmvBaseActivity.EmvBaseCallback callback) {
        super.startProcess(emvCardControlEntity, callback);
    }

    @Override
    public InputAmountCallBack getInputAmountCallBack() {
        return inputAmountCallBack;
    }

    @Override
    public void finishActivity() {
        log.debug("finish activity---");
        startLogic();
    }

    @Override
    public void finishActivity(String msg) {
        super.finishActivity(msg);
        log.debug("finish activity msg---");
        startLogic();
    }

    @Override
    public void onBackPressed() {
        log.debug("onBackPressed------");
        startLogic();
    }

    private long clickTime = 0;

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        log.debug("onKeyDown--------------");
        if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
            if (System.currentTimeMillis() - clickTime > 1000) {
                clickTime = System.currentTimeMillis();
                ToastUtils.showShort(getString(R.string.home_double_click_to_exit));
            } else {
                Process.killProcess(Process.myPid());
                System.exit(1);
            }
        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onStop() {
        super.onStop();
        log.debug("onStop---------");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        log.debug("onDestroy-----------");
    }

    @Override
    public void showDialog(boolean enable, String title, String msg) {
        super.processDialog(enable, title, msg);
    }

    @Override
    public void confirmDialog(String title, String msg, String cancelBtnStr, String confirmBtnStr, ConfirmAndCancelListener listener) {
        processDialog(false, null, null);
        super.confirmAndCancelDialog(title, msg, cancelBtnStr, confirmBtnStr, listener);
    }

    @Override
    public void showContinuePrintDialog(ContinuePrintDialog.OnContinueListener onContinueListener) {
        super.continuePrintDialog(onContinueListener);
    }

    @Override
    public void transSuccess(TransRecordEntity transRecordEntity) {
        super.processDialog(false, "", "");
        handler.post(new Runnable() {
            @Override
            public void run() {
                startCheckCardExist();
                ResultBean result = new ResultBean(true, null);
                startFragment(CommonResultFragment.newInstance(result), false);
            }
        });
    }

    @Override
    public void transFail(final String errorMsg, TransRecordEntity transRecordEntity) {
        log.debug("transFail");
        super.processDialog(false, "", "");
        handler.post(new Runnable() {
            @Override
            public void run() {
                startCheckCardExist();
                ResultBean result = new ResultBean(false, errorMsg);
                startFragment(CommonResultFragment.newInstance(result), false);
            }
        });
    }
}
