package cn.nexgo.inbas.controller.mechantcenter.syssetting.view;


import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import butterknife.BindView;
import butterknife.OnClick;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.widget.EditSettingsDialog;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.SetupEntity;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SetupTermFragment.java
 * Usage         :
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/24
 * Modification  : Created file

 **************************************************************************************************/
public class SetupTermFragment extends BaseFragment {


    @BindView(R.id.tv_terminal_id)
    TextView tvTerminalId;
    @BindView(R.id.rl_terminal_id)
    LinearLayout rlTerminalId;
    @BindView(R.id.dotted_line)
    View dottedLine;
    @BindView(R.id.tv_merchant_id)
    TextView tvMerchantId;
    @BindView(R.id.rl_merchant_id)
    LinearLayout rlMerchantId;
    @BindView(R.id.tv_merchant_name)
    TextView tvMerchantName;
    @BindView(R.id.rl_merchant_name)
    LinearLayout rlMerchantName;
    @BindView(R.id.tv_merchant_addr1)
    TextView tvMerchantAddr1;
    @BindView(R.id.rl_merchant_addr1)
    LinearLayout rlMerchantAddr1;
    @BindView(R.id.tv_merchant_addr2)
    TextView tvMerchantAddr2;
    @BindView(R.id.rl_merchant_addr2)
    LinearLayout rlMerchantAddr2;
    @BindView(R.id.tv_merchant_addr3)
    TextView tvMerchantAddr3;
    @BindView(R.id.rl_merchant_addr3)
    LinearLayout rlMerchantAddr3;
    @BindView(R.id.tv_merchant_tel)
    TextView tvMerchantTel;
    @BindView(R.id.rl_merchant_tel)
    LinearLayout rlMerchantTel;
    @BindView(R.id.tv_currency_code)
    TextView tvCurrencyCode;
    @BindView(R.id.rl_currency_code)
    LinearLayout rlCurrencyCode;
    @BindView(R.id.tv_currency_name)
    TextView tvCurrencyName;
    @BindView(R.id.rl_currency_name)
    LinearLayout rlCurrencyName;
    @BindView(R.id.tv_amount_decimal)
    TextView tvAmountDecimal;
    @BindView(R.id.rl_amount_decimal)
    LinearLayout rlAmountDecimal;
    @BindView(R.id.tv_country_code)
    TextView tvCountryCode;
    @BindView(R.id.rl_country_code)
    LinearLayout rlCountryCode;
    private SetupEntity entity;

    public SetupTermFragment() {
        // Required empty public constructor
    }


    @Override
    protected int getLayoutId() {
        return R.layout.syssetting_activity_term_fragment;
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        this.entity = GData.getInstance().getSetupEntity();
    }

    @Override
    protected void initPresenter() {
    }

    @Override
    protected void initView(View view) {
        tvTerminalId.setText(entity.getTermTID());
        tvMerchantId.setText(entity.getTermMID());
        tvMerchantName.setText(entity.getTermMerchName());
        tvMerchantAddr1.setText(entity.getTermMerchAddr1());
        tvMerchantAddr2.setText(entity.getTermMerchAddr2());
        tvMerchantAddr3.setText(entity.getTermMerchAddr3());
        tvMerchantTel.setText(entity.getTermMerchTel());
        tvCurrencyCode.setText(entity.getTermCurrencyCode());
        tvCountryCode.setText(entity.getTermCountryCode());
        tvCurrencyName.setText(entity.getTermCurrencyName());
        tvAmountDecimal.setText(String.valueOf(entity.getTermAmountDecimalLen()));
    }

    @OnClick({R.id.rl_terminal_id, R.id.rl_currency_code, R.id.rl_country_code, R.id.rl_merchant_id, R.id.rl_merchant_name, R.id.rl_merchant_addr1, R.id.rl_merchant_addr2, R.id.rl_merchant_addr3, R.id.rl_merchant_tel, R.id.rl_currency_name, R.id.rl_amount_decimal})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.rl_terminal_id:
                doEdit(tvTerminalId, EditSettingsDialog.InputType.NUM, 8,8, 0, -1, getString(R.string.setting_terminal_id));
                break;
            case R.id.rl_merchant_id:
                doEdit(tvMerchantId, EditSettingsDialog.InputType.NUM, 15,15, 0, -1, getString(R.string.setting_merchant_id));
                break;
            case R.id.rl_merchant_name:
                doEdit(tvMerchantName, EditSettingsDialog.InputType.STR, 1,126, 0, -1, getString(R.string.setting_merchant_name));
                break;
            case R.id.rl_merchant_addr1:
                doEdit(tvMerchantAddr1, EditSettingsDialog.InputType.STR, 1, 126, 0, -1, getString(R.string.setting_merchant_addr1));
                break;
            case R.id.rl_merchant_addr2:
                doEdit(tvMerchantAddr2, EditSettingsDialog.InputType.STR, 1, 126, 0, -1, getString(R.string.setting_merchant_addr2));
                break;
            case R.id.rl_merchant_addr3:
                doEdit(tvMerchantAddr3, EditSettingsDialog.InputType.STR, 1, 126, 0, -1, getString(R.string.setting_merchant_addr3));
                break;
            case R.id.rl_merchant_tel:
                doEdit(tvMerchantTel, EditSettingsDialog.InputType.NUM, 8, 15, 0, -1, getString(R.string.setting_merchant_tel));
                break;
            case R.id.rl_currency_code:
                doEdit(tvCurrencyCode, EditSettingsDialog.InputType.NUM, 3, 3, 0, -1, getString(R.string.setting_currency_code));
                break;
            case R.id.rl_country_code:
                doEdit(tvCountryCode, EditSettingsDialog.InputType.NUM, 3, 3, 0, -1, getString(R.string.setting_country_code));
                break;
            case R.id.rl_currency_name:
                doEdit(tvCurrencyName, EditSettingsDialog.InputType.STR, 3, 126, 0, -1, getString(R.string.setting_currency_name));
                break;
            case R.id.rl_amount_decimal:
                doEdit(tvAmountDecimal, EditSettingsDialog.InputType.NUM, 1, 1, 0, 3, getString(R.string.setting_amount_decimal));
                break;
        }
    }


    private void doEdit(final TextView content, EditSettingsDialog.InputType inputType, int minlen, int maxLen, long minValue, long maxValue, String title) {

        final EditSettingsDialog dialog = new EditSettingsDialog(getContext(), inputType, minlen, maxLen);
        dialog.setTitle(title);
        dialog.setMinValue(minValue);
        dialog.setMaxValue(maxValue);
        dialog.setDefaultValue(content.getText().toString());
        dialog.setOnBackClickListener(new EditSettingsDialog.OnBackClickListener() {
            @Override
            public void onBackClick() {
                dialog.dismiss();
            }
        });
        dialog.setOnOkClickListener(new EditSettingsDialog.OnOkClickListener() {
            @Override
            public void onOkClick() {
                content.setText(dialog.getLine2text());
                dialog.dismiss();
            }
        });
        dialog.show();
    }


    private void saveSettings() {
        entity.setTermTID(tvTerminalId.getText().toString());
        entity.setTermMID(tvMerchantId.getText().toString());
        entity.setTermMerchName(tvMerchantName.getText().toString());
        entity.setTermMerchAddr1(tvMerchantAddr1.getText().toString());
        entity.setTermMerchAddr2(tvMerchantAddr2.getText().toString());
        entity.setTermMerchAddr3(tvMerchantAddr3.getText().toString());
        entity.setTermMerchTel(tvMerchantTel.getText().toString());
        entity.setTermCurrencyCode(tvCurrencyCode.getText().toString());
        entity.setTermCountryCode(tvCountryCode.getText().toString());
        entity.setTermCurrencyName(tvCurrencyName.getText().toString());
        entity.setTermAmountDecimalLen(Integer.parseInt(tvAmountDecimal.getText().toString()));

        DataOpenHelper.getInstance().getSetupRepository().update(entity);
    }

    @Override
    public void onPause() {
        super.onPause();
        saveSettings();
    }
}
