package cn.nexgo.inbas.controller.global;


import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : TransType.java
 * Usage         : Transaction types and corresponding information enumeration
 * Version       : 1
 * Author        : lee
 * Date          : 2018/10/11
 * Modification  : Created file

 **************************************************************************************************/
public enum TransType {

    LOGON(R.string.trans_name_logon, R.string.trans_name_logon, "0800", "", "", "00", false, false, false),

    LOGOUT(R.string.trans_name_logout, R.string.trans_name_logout, "0820", "", "", "00", false, false, false),

    REVERSAL(R.string.trans_name_reversal, 0, "0400", "", "", "00", false, false, false),

    SALE(R.string.trans_name_sale, R.string.trans_name_sale, "0200", "000000", "00", "22", true, true, true),

    VOID(R.string.trans_name_void, R.string.trans_name_void, "0200", "020000", "00", "23", true, true, true),

    REFUND(R.string.trans_name_refund, R.string.trans_name_refund, "0220", "200000", "00", "25", true, false, true),

    BALANCE(R.string.trans_name_balance, R.string.trans_name_balance, "0200", "310000", "00", "01", false, false, true),

    SETTLE(R.string.trans_name_settle, R.string.trans_name_settle, "0500", "", "", "00", false, false, true),

    TIP(R.string.trans_name_tip, R.string.trans_name_tip, "0220", "000000", "00", "34", true, false, true),

    ADJUST(R.string.trans_name_adjust, R.string.trans_name_adjust, "0220", "000000", "00", "30", true, false, true),

    SCRIPT_NOTIFY(0, 0, "0620", "", "", "00", false, false, false);

    /**
     * 交易名称
     * Transaction name
     */
    private final int name;
    /**
     * 打印时交易名称 Transaction name for print
     */
    private final int printName;
    /**
     * 消息类型
     * Message Type
     */
    private final String msgType;
    /**
     * 交易处理码3域
     * Field 3
     */
    private final String procCode;
    /**
     * 服务点条件码25域
     * Field 25
     */
    private final String conditionCode;
    /**
     * 消息类型码60.1域
     * Field 60.1
     */
    private final String funcCode;
    /**
     * 交易是否存数据库
     * Is the transaction saved to the database?
     */
    private boolean saveRecord;
    /**
     * 交易异常时是否需要冲正
     * Is need reversal when transaction is abnormal?
     */
    private boolean reversal;
    /**
     * 交易发送前是否需要发提前包（脚本上送，冲正，电子签名等等）
     * Is need to send advance packages before sending this transaction?(Such as: Script,reversal,electronic signature)
     */
    private boolean preSend;

    TransType(int name, int printName, String msgType, String procCode, String conditionCode, String funcCode, boolean saveRecord, boolean reversal, boolean preSend) {
        this.name = name;
        this.printName = printName;
        this.msgType = msgType;
        this.procCode = procCode;
        this.conditionCode = conditionCode;
        this.funcCode = funcCode;
        this.saveRecord = saveRecord;
        this.reversal = reversal;
        this.preSend = preSend;
    }

    public String getMsgType() {
        return msgType;
    }

    public String getProcCode() {
        return procCode;
    }

    public String getFuncCode() {
        return funcCode;
    }

    public int getName() {
        return name;
    }

    public int getPrintName() {
        return printName;
    }

    public boolean isSaveRecord() {
        return saveRecord;
    }

    public boolean isPreSend() {
        return preSend;
    }

    public boolean isReversal() {
        return reversal;
    }

    public String getConditionCode() {
        return conditionCode;
    }
    }
