package cn.nexgo.inbas.components.input.readcard.internal;

import android.text.TextUtils;

import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.SdkResult;
import com.nexgo.oaf.apiv3.device.reader.CardInfoEntity;
import com.nexgo.oaf.apiv3.device.reader.CardReader;
import com.nexgo.oaf.apiv3.device.reader.CardSlotTypeEnum;
import com.nexgo.oaf.apiv3.device.reader.OnCardInfoListener;

import java.util.Calendar;
import java.util.HashSet;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.components.input.readcard.ReadCardData;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ToastUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public class ReadCardPresenter implements ReadCardContract.Presenter {

    private final ReadCardContract.View view;
    private CardReader cardReader;
    private boolean isReadCard;
    private ReadCardData readCardData;

    public ReadCardPresenter(ReadCardContract.View view) {
        this.view = view;
        cardReader = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCardReader();
    }

    @Override
    public boolean startReadCard(ReadCardData readCardData) {
        this.readCardData = readCardData;

        HashSet<CardSlotTypeEnum> slot = new HashSet<>();
        if (readCardData.isSupportMag()) {
            slot.add(CardSlotTypeEnum.SWIPE);
        }
        if (readCardData.isSupportICC()) {
            slot.add(CardSlotTypeEnum.ICC1);
        }
        if (readCardData.isSupportCTLS()) {
            slot.add(CardSlotTypeEnum.RF);
        }

        if (slot.isEmpty()) {
            view.showManualCard();
            return false;
        } else {
            view.showReadCard();
        }

        int ret = cardReader.searchCard(slot, 99999, mCardInfoListener);
        if (ret == SdkResult.Success) {
            isReadCard = true;
            return true;
        } else {
            isReadCard = false;
            return false;
        }
    }

    @Override
    public void stopReadCard() {
        if (isReadCard) {
            cardReader.stopSearch();
            isReadCard = false;
        }
    }

    @Override
    public void cancelReadCard() {
        cardReader.stopSearch();
        if (isReadCard) {
            view.onCancel();
        }
    }

    @Override
    public void commitManualCardResult(String pan, String expiredDate) {
        // check expiredDate

        expiredDate = expiredDate.replace("/", "");

        if (expiredDate.length() != 4) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.error_card_expired_date));
            return;
        }

        String month = expiredDate.substring(0, 2);
        String year = expiredDate.substring(2, 4);
        int mm = Integer.parseInt(month);

        if (mm <= 0 || mm >= 13) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.error_invalid_month));
            return;
        }

        int yy = Integer.parseInt(year);

        final Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(Calendar.YEAR);
        int currentMonth = calendar.get(Calendar.MONTH) + 1;

        int millenium = (currentYear / 1000) * 1000;

        if (yy + millenium < currentYear) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.error_card_expired));
            return;
        } else if (yy + millenium == currentYear && mm < currentMonth) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.error_card_expired));
            return;
        }

        ManualCard manualCard = new ManualCard();
        manualCard.setPan(pan);
        manualCard.setExpiredDate(expiredDate);
        view.onManual(manualCard);
    }

    private OnCardInfoListener mCardInfoListener = new OnCardInfoListener() {
        @Override
        public void onCardInfo(int retCode, CardInfoEntity cardInfo) {
            isReadCard = false;
            switch (retCode) {
                case SdkResult.Success:
                    switch (cardInfo.getCardExistslot()) {
                        case SWIPE:
                            //Tk2 Data is null
                            if (TextUtils.isEmpty(cardInfo.getTk2())) {
                                view.onError();
                                return;
                            }
                            MagCard magCard = new MagCard();
                            magCard.setCardNo(cardInfo.getCardNo());
                            magCard.setICC(cardInfo.isICC());

                            if((magCard.getCardNo() == null) ||
                                    (magCard.getCardNo().length() < 13) ||
                                    (magCard.getCardNo().length() > 19)){  //  pan error
                                view.onError();
                                break;
                            }

                            magCard.setTk1(cardInfo.getTk1());
                            String tk2 = cardInfo.getTk2().toUpperCase();
                            tk2 = tk2.replace("=", "D");
                            magCard.setTk2(tk2);
                            magCard.setTk3(cardInfo.getTk3());

                            magCard.setTk1Valid(cardInfo.isTk1Valid());
                            magCard.setTk2Valid(cardInfo.isTk2Valid());
                            magCard.setTk3Valid(cardInfo.isTk3Valid());

                            magCard.setExpiredDate(cardInfo.getExpiredDate());
                            magCard.setServiceCode(cardInfo.getServiceCode());
                            view.onMagCard(magCard);
                            break;
                        case ICC1:
                            view.onICC();
                            break;
                        case RF:
                            view.onCTLS();
                            break;
                        default:
                            break;
                    }
                    break;
                case SdkResult.TimeOut:
                    view.onTimeOut();
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onSwipeIncorrect() {
            if (readCardData != null) {
                startReadCard(readCardData);
            }
        }

        @Override
        public void onMultipleCards() {
            if (readCardData != null) {
                startReadCard(readCardData);
            }
        }
    };
}
