package cn.nexgo.inbas.components.input.readcard;

import android.os.Parcel;
import android.os.Parcelable;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/13
 * Modify          : create file
 **************************************************************************************************/
public class ReadCardData implements Parcelable {
    private boolean supportMag = false;
    private boolean supportICC = false;
    private boolean supportCTLS = false;
    private boolean supportManual = false;
    private int timeout = 60;

    private long amount;
    private int decimal;
    private String currencySymbol;

    private String readCardPrompt;

    public ReadCardData(boolean supportMag, boolean supportICC, boolean supportCTLS, boolean supportManual, int timeout) {
        this.supportMag = supportMag;
        this.supportICC = supportICC;
        this.supportCTLS = supportCTLS;
        this.supportManual = supportManual;
        this.timeout = timeout;
    }

    public ReadCardData(boolean supportMag, boolean supportICC, boolean supportCTLS, boolean supportManual, int timeout, String readCardPrompt) {
        this.supportMag = supportMag;
        this.supportICC = supportICC;
        this.supportCTLS = supportCTLS;
        this.supportManual = supportManual;
        this.timeout = timeout;
        this.readCardPrompt = readCardPrompt;
    }


    public ReadCardData() {
    }

    protected ReadCardData(Parcel in) {
        supportMag = in.readByte() != 0;
        supportICC = in.readByte() != 0;
        supportCTLS = in.readByte() != 0;
        supportManual = in.readByte() != 0;
        timeout = in.readInt();
        amount = in.readLong();
        decimal = in.readInt();
        currencySymbol = in.readString();
        readCardPrompt =  in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (supportMag ? 1 : 0));
        dest.writeByte((byte) (supportICC ? 1 : 0));
        dest.writeByte((byte) (supportCTLS ? 1 : 0));
        dest.writeByte((byte) (supportManual ? 1 : 0));
        dest.writeInt(timeout);
        dest.writeLong(amount);
        dest.writeInt(decimal);
        dest.writeString(currencySymbol);
        dest.writeString(readCardPrompt);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ReadCardData> CREATOR = new Creator<ReadCardData>() {
        @Override
        public ReadCardData createFromParcel(Parcel in) {
            return new ReadCardData(in);
        }

        @Override
        public ReadCardData[] newArray(int size) {
            return new ReadCardData[size];
        }
    };

    public boolean isSupportMag() {
        return supportMag;
    }

    public void setSupportMag(boolean supportMag) {
        this.supportMag = supportMag;
    }

    public boolean isSupportICC() {
        return supportICC;
    }

    public void setSupportICC(boolean supportICC) {
        this.supportICC = supportICC;
    }

    public boolean isSupportCTLS() {
        return supportCTLS;
    }

    public void setSupportCTLS(boolean supportCTLS) {
        this.supportCTLS = supportCTLS;
    }

    public boolean isSupportManual() {
        return supportManual;
    }

    public void setSupportManual(boolean supportManual) {
        this.supportManual = supportManual;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }


    public long getAmount() {
        return amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public int getDecimal() {
        return decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public String getReadCardPrompt() {
        return readCardPrompt;
    }

    public void setReadCardPrompt(String readCardPrompt) {
        this.readCardPrompt = readCardPrompt;
    }

    @Override
    public String toString() {
        return "ReadCardData{" +
                "supportMag=" + supportMag +
                ", supportICC=" + supportICC +
                ", supportCTLS=" + supportCTLS +
                ", supportManual=" + supportManual +
                ", timeout=" + timeout +
                ", amount=" + amount +
                ", decimal=" + decimal +
                ", currencySymbol='" + currencySymbol + '\'' +
                '}';
    }
}
