package cn.nexgo.inbas.components.input.pin;

import android.app.Activity;
import android.graphics.Paint;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.nexgo.oaf.apiv3.device.pinpad.PinpadLayoutEntity;

import butterknife.BindView;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.utils.TimeCounter;
import cn.nexgo.inbas.common.widget.ToolBar;
import cn.nexgo.inbas.common.widget.autofittext.AutoFitTextView;
import cn.nexgo.inbas.common.widget.keyboard.PinKeyBoard;
import cn.nexgo.inbas.components.input.pin.internal.InputPinCallBack;
import cn.nexgo.inbas.components.input.pin.internal.InputPinContract;
import cn.nexgo.inbas.components.input.pin.internal.InputPinPresenter;
import cn.nexgo.utils.AppLogUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/11
 * Modify          : create file
 **************************************************************************************************/

public class InputPinFragment extends BaseFragment implements InputPinContract.View {
    @BindView(R.id.tb)
    ToolBar tb;
    @BindView(R.id.tv_pin_mark)
    TextView tvPinMark;
    @BindView(R.id.tv_pin)
    TextView tvPin;
    @BindView(R.id.kb_input_pin)
    PinKeyBoard kbInputPin;
    @BindView(R.id.tv_amount)
    AutoFitTextView tvAmount;
    @BindView(R.id.lv_amount)
    LinearLayout lvAmount;
    @BindView(R.id.tv_pin_line)
    ImageView tvPinLine;

    private InputPinData inputPinData;
    private InputPinCallBack inputPinCallBack;
    private InputPinPresenter inputPinPresenter;

    public static final String INPUT_PIN_DATA = "input_pin_data";

    private OnInputPinCallBack onInputPinCallBack;
    private TimeCounter timeCounter;
    private String title;


    public interface OnInputPinCallBack {
        InputPinCallBack getInputPinCallBack();
    }


    @Override
    protected int getLayoutId() {
        return R.layout.input_pin_fragment;
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        onInputPinCallBack = (OnInputPinCallBack) getActivity();
        inputPinCallBack = onInputPinCallBack.getInputPinCallBack();

        Bundle bundle = getArguments();
        if (bundle != null) {
            inputPinData = bundle.getParcelable(INPUT_PIN_DATA);
            title = bundle.getString("title");
        }
    }

    @Override
    protected void initPresenter() {
        inputPinPresenter = new InputPinPresenter(this, inputPinData);
    }

    @Override
    protected void initView(View view) {
        //keep screen on
        Window win = getActivity().getWindow();
        win.setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        //close menu
        win.addFlags(5);
        //close home
        win.addFlags(3);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {//当系统版本是5.1.1时，可以使用Settings
            //close pulldown window
            Settings.System.putInt(getContext().getContentResolver(), "status_bar_disabled", 1);
        }
        //去掉虚拟按键全屏显示
        win.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);

        tb.setRightlab(String.valueOf(inputPinData.getRemainTimes()));
        tvPin.getPaint().setAntiAlias(true);
        tvPin.getPaint().setFlags(Paint.UNDERLINE_TEXT_FLAG);

        AppLogUtils.debug(true, "input pin fragment", "input pin fragment->" + inputPinData.getAmountBean().toString());
        if ((inputPinData.getAmountBean() == null) || (inputPinData.getAmountBean().getLongValue() <= 0)) {
            lvAmount.setVisibility(View.INVISIBLE);
        } else {
            tvAmount.setText(inputPinData.getAmountBean().toString());
        }

        tb.showBackBtn(false);
//        tb.setTitle(getString(R.string.pin));
//        tb.setTitle(title == null ? getString(R.string.pin) : title);

        if(!inputPinData.isOfflinePin()){
            tb.setTitle(getString(R.string.input_enter_onlinepin));
        } else {
            tb.setTitle(getString(R.string.input_enter_offlinepin));
        }
    }

    public static <T extends Activity & OnInputPinCallBack> InputPinFragment newInstance(String title, InputPinData inputPinData, T callback) {

        InputPinFragment inputPinFragment = new InputPinFragment();
        Bundle b = new Bundle();
        b.putParcelable(INPUT_PIN_DATA, inputPinData);
        b.putString("title", title);
        inputPinFragment.setArguments(b);
        return inputPinFragment;
    }

    public void startInputPin(InputPinData inputPinData) {
        inputPinPresenter.startInputPin(inputPinData);
    }

    @Override
    public void onResume() {
        super.onResume();
        kbInputPin.post(new Runnable() {
            @Override
            public void run() {
                startInputPin(inputPinData);
            }
        });
    }

    @Override
    public void onPause() {
        super.onPause();
        inputPinPresenter.cancelInputPin();
        timeCounter.cancel();
    }

    @Override
    public void showPinClear() {
        tvPin.setText("");
        tvPinLine.setVisibility(View.VISIBLE);
        kbInputPin.refreshUI(tvPin.getText().length());
    }

    @Override
    public void showPinMask() {
        tvPin.append("*");
        tvPinLine.setVisibility(View.GONE);
        kbInputPin.refreshUI(tvPin.getText().length());
    }

    @Override
    public void startTimeOutCountDown(int timeOut) {
        if (timeCounter != null) {
            timeCounter.cancel();
        }
        timeCounter = new TimeCounter();
        timeCounter.startTimer(timeOut, timerListener);
    }

    private TimeCounter.Listener timerListener = new TimeCounter.Listener() {
        @Override
        public void onTimerProcess(long time) {
            tb.setRightlab(String.valueOf(time));
        }

        @Override
        public void onFinish() {
            inputPinPresenter.onInputPinTimeOut();
            if (inputPinCallBack != null) {
                inputPinCallBack.onTimeOut();
            }
        }
    };

    @Override
    public void showPinError() {
        if (inputPinCallBack != null) {
            inputPinCallBack.onError(InputPinCallBack.ErrorType.TYPE1);
        }
        timeCounter.cancel();
    }

    @Override
    public void showPinTimeOut() {
        if (inputPinCallBack != null) {
            inputPinCallBack.onTimeOut();
        }
        inputPinPresenter.cancelInputPin();
        timeCounter.cancel();
    }

    @Override
    public void showPinConfirm(byte[] pin) {
        if (inputPinCallBack != null) {
            inputPinCallBack.onPin(pin);
        }
        inputPinPresenter.cancelInputPin();
        timeCounter.cancel();
    }

    @Override
    public void pinPass() {
        if (inputPinCallBack != null) {
            inputPinCallBack.onPass();
        }
        inputPinPresenter.cancelInputPin();
        timeCounter.cancel();
    }

    @Override
    public void showPinCancel() {
        if (inputPinCallBack != null) {
            inputPinCallBack.onCancel();
        }
        timeCounter.cancel();
    }

    @Override
    public boolean isActive() {
        return isAdded();
    }

    @Override
    public PinpadLayoutEntity getPinPadLayoutEntity() {
        return kbInputPin.getPinpadLayoutEntity();
    }

    @Override
    public void setPinNum(byte[] bytes) {
        kbInputPin.setKeyNum(bytes);
    }

    @Override
    public void setPinLen(int[] pinLen) {
        kbInputPin.setPinLen(pinLen);
    }
}
