package cn.nexgo.inbas.components.input.amount;

import android.os.Parcel;
import android.os.Parcelable;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/13
 * Modify          : create file
 **************************************************************************************************/
public class InputAmountData implements Parcelable {
    private int decimals;
    private String currencySymbol;
    private long maxAmount = 999_999_999L;
    private long minAmount = 1;
    private long defaulAmount = 0;
    private int timeout = 60;

    public InputAmountData() {
    }

    public InputAmountData(int decimals, String currencySymbol) {
        this.decimals = decimals;
        this.currencySymbol = currencySymbol;
    }

    public InputAmountData(int decimals, String currencySymbol, long maxAmount, long minAmount, long defaulAmount, int timeout) {
        this.decimals = decimals;
        this.currencySymbol = currencySymbol;
        this.maxAmount = maxAmount;
        this.minAmount = minAmount;
        this.defaulAmount = defaulAmount;
        this.timeout = timeout;
    }

    protected InputAmountData(Parcel in) {
        decimals = in.readInt();
        currencySymbol = in.readString();
        maxAmount = in.readLong();
        minAmount = in.readLong();
        defaulAmount = in.readLong();
        timeout = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(decimals);
        dest.writeString(currencySymbol);
        dest.writeLong(maxAmount);
        dest.writeLong(minAmount);
        dest.writeLong(defaulAmount);
        dest.writeInt(timeout);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<InputAmountData> CREATOR = new Creator<InputAmountData>() {
        @Override
        public InputAmountData createFromParcel(Parcel in) {
            return new InputAmountData(in);
        }

        @Override
        public InputAmountData[] newArray(int size) {
            return new InputAmountData[size];
        }
    };

    public int getDecimals() {
        return decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public long getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(long maxAmount) {
        this.maxAmount = maxAmount;
    }

    public long getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(long minAmount) {
        this.minAmount = minAmount;
    }

    public long getDefaulAmount() {
        return defaulAmount;
    }

    public void setDefaulAmount(long defaulAmount) {
        this.defaulAmount = defaulAmount;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String toString() {
        return "InputAmountData{" +
                "decimals=" + decimals +
                ", currencySymbol='" + currencySymbol + '\'' +
                ", maxAmount=" + maxAmount +
                ", minAmount=" + minAmount +
                ", defaulAmount=" + defaulAmount +
                ", timeout=" + timeout +
                '}';
    }
}
