package cn.nexgo.inbas.components.emv.contract;

import java.util.List;

import cn.nexgo.inbas.common.widget.CardNoConfirmDialog;
import cn.nexgo.inbas.common.widget.SeePhoneDialog;
import cn.nexgo.inbas.components.emv.EmvBaseActivity;
import cn.nexgo.inbas.components.emv.IEmvCore;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.emv.fragment.selectapp.SelectAppCallBack;
import cn.nexgo.inbas.components.input.amount.InputAmountData;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;
import cn.nexgo.inbas.components.input.pin.InputPinData;
import cn.nexgo.inbas.components.input.pin.internal.InputPinCallBack;
import cn.nexgo.inbas.components.input.readcard.ReadCardData;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardCallBack;


/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Sandy(jiangsuyong@nexgo.cn)
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/
public interface EmvBaseContract {

    interface Presenter {

        void startCardProcess(EmvCardControlEntity emvCardControlEntity, EmvBaseActivity.EmvBaseCallback callback);


        /**
         * initEmvTermConfig ,include country code, currency code, terminal Capabilities...
         */
        void initEmvTermConfig();


        /**
         * initEmvContactlessTermConfig ,include paywave, paypass parameters...
         */
        void initEmvContactlessTermConfig();

        IEmvCore getEmvCore();

        void finishProcess();
    }

    interface View {

        void onReadCard(String title, ReadCardData readCardData, ReadCardCallBack cardCallBack);

        /**
         * EmvRequestAmount
         */
        void onEmvRequestAmount(String title, InputAmountData amountData, InputAmountCallBack callBack);

        /**
         * EmvSelectApp
         *
         * @param list
         */
        void onEmvRequestSelectApp(List<String> list, SelectAppCallBack callBack);

        void showDialog(boolean show, String title, String msg);

        /**
         * onEmvRequestConfirmCardNumber
         *
         * @param pan
         * @param transAmount
         */
        void onEmvRequestConfirmCardNumber(String pan, String transAmount, CardNoConfirmDialog.OnClickListener confirmPanCallBack);

        void onEmvRequestInputPin(String title, InputPinData inputPinData, InputPinCallBack callBack);

        void onEmvRequestSeePhone(SeePhoneDialog.OnClickListener seePhoneCallBack);

        void finishActivity(String msg);
    }
}
