package cn.nexgo.inbas.components.emv.bean;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : Hassan(huacong@nexgo.cn)
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public enum EmvTransState {
    /**
     * ONLINE APPROVE
     */
    EMV_ONLINE_APPROVE,

    /**
     * OFFLINE APPROVE
     */
    EMV_OFFLINE_APPROVE,

    /**
     *  request online
     */
    EMV_ONLINE_REQUEST,

    /**
     * ONLINE_DECLINED, need reversal
     */
    EMV_ERR_ONLINE_DECLINED_REVERSAL,

    /**
     * OFFLINE_DECLINED, do not need reversal
     */
    EMV_ERR_OFFLINE_DECLINED,

    /**
     * emv cancel
     */
    EMV_ERR_CANCEL,

    /**
     * emv need fallback
     */
    EMV_ERR_FALLBACK,

    /**
     * online decline , err response, not need reversal
     */
    EMV_ERR_ONLINE_DECLINED_RESPONSE,

    /**
     * card block
     */
    EMV_ERR_CARD_BLOCK,

    /**
     * no aid match, should fallback
     */
    EMV_ERR_UNMATCH_AID,

    /**
     * app block
     */
    EMV_ERR_APP_BLOCK,

    /**
     * app ineffect
     */
    EMV_ERR_APP_INEFFECT,

    /**
     * app expired
     */
    EMV_ERR_APP_EXPIRED,

    /**
     * please try other interface
     */
    EMV_ERR_OTHER_INTERFACE,



    /**
     * ERR_OTHER
     */
    EMV_ERR_OTHER;

    /**
     * need Reversal
     */
    private boolean isNeedReversal;

//    EmvTransState(boolean isNeedReversal) {
//        this.isNeedReversal = isNeedReversal;
//    }

    public boolean isNeedReversal() {
        return isNeedReversal;
    }




}
