package cn.nexgo.inbas.components.emv;

import android.os.Environment;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.nexgo.common.FileUtils;
import com.nexgo.oaf.apiv3.emv.AidEntity;
import com.nexgo.oaf.apiv3.emv.CapkEntity;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import cn.nexgo.utils.BaseUtils;

/**
 * cn.nexgo.inbas.components.emv
 * Author: zhaojiangon 2018/1/31 17:31.
 * Modified by Brad2018/4/23 : add test file
 */

public class EmvUtils {
    public static final String EMV_CTLS_PAYPASS = "paypass";
    public static final String EMV_CTLS_PASS_9F33 = "9F33";
    public static final String EMV_CTLS_PASS_9F40 = "9F40";
    public static final String EMV_CTLS_PASS_9F6D = "9F6D";
    public static final String EMV_CTLS_PASS_DF811B = "DF811B";
    public static final String EMV_CTLS_PASS_DF8125= "DF8125";
    public static final String EMV_CTLS_PASS_DF811E = "DF811E";
    public static final String EMV_CTLS_PASS_DF812C = "DF812C";
    public static final String EMV_CTLS_PASS_DF811F = "DF811F";
    public static final String EMV_CTLS_PASS_DF8117 = "DF8117";
    public static final String EMV_CTLS_PASS_DF8118 = "DF8118";
    public static final String EMV_CTLS_PASS_DF8119 = "DF8119";

    public static final String EMV_CTLS_PAYWAVE = "paywave";
    public static final String EMV_CTLS_PAYWAVE_9F66 = "9F66";
    public static final String EMV_CTLS_PAYWAVE_9F33 = "9F33";
    public static final String EMV_CTLS_PAYWAVE_9F40 = "9F40";
    public static final String EMV_CTLS_PAYWAVE_DF03 = "DF03";


    public static List<AidEntity> getAidList(){
        List<AidEntity> aidEntityList = new ArrayList<>();
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonArray jsonArray;
        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
                "/inbas_aid.json";

        // if testFile exists, load test file, or load from Assets
        // convert json string to JsonArray
        if (FileUtils.isFileExists(testFile)) {
            jsonArray = parser.parse(readFile(testFile)).getAsJsonArray();
        } else {
            jsonArray = parser.parse(readAssetsTxt("inbas_aid.json")).getAsJsonArray();
        }
        if (jsonArray == null){
            return null;
        }

        for (JsonElement user : jsonArray) {
            AidEntity userBean = gson.fromJson(user, AidEntity.class);
            aidEntityList.add(userBean);
        }
        return aidEntityList;
    }


    public static List<CapkEntity> getCapkList(){
        List<CapkEntity> capkEntityList = new ArrayList<>();
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
                "/inbas_capk.json";

        // if testFile exists, load test file, or load from Assets
        // convert json string to JsonArray
        JsonArray jsonArray;
        if (FileUtils.isFileExists(testFile)) {
            jsonArray = parser.parse(readFile(testFile)).getAsJsonArray();
        } else {
            jsonArray = parser.parse(readAssetsTxt("inbas_capk.json")).getAsJsonArray();
        }
        if (jsonArray == null){
            return null;
        }

        for (JsonElement user : jsonArray) {
            CapkEntity userBean = gson.fromJson(user, CapkEntity.class);
            capkEntityList.add(userBean);
        }
        return capkEntityList;
    }

//    public static HashMap<String, String> getCtlsCfg() {
//        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
//                "/emvcontactlesscfg.xml";
//        InputStream is;
//        HashMap<String, String> hashMap = new HashMap<>();
//        try {
//            // if testFile exists, load test file, or load from Assets
//            if (FileUtils.isFileExists(testFile)) {
//                is = new FileInputStream(testFile);
//            } else {
//                is = BaseUtils.getApp().getAssets().open("emvcontactlesscfg.xml");
//            }
//            try {
//                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
//                Document doc = documentBuilder.parse(is);
//                Element root = doc.getDocumentElement();
//                Element[] attributeItems = getElementsByName(root, "attribute");
//                if (attributeItems == null || attributeItems.length == 0) {
//                    throw new IOException("config error");
//                }
//                for (Element attribute : attributeItems){
//                    hashMap.put(getElementAttr(attribute, "tag"), getElementAttr(attribute, "value"));
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//            is.close();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return hashMap;
//    }

    public static HashMap<String, String> getCtlsCfgPaypass() {
        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
                "/emvcontactlesscfg.xml";
        InputStream is;
        HashMap<String, String> hashMap = new HashMap<>();
        try {
            // if testFile exists, load test file, or load from Assets
            if (FileUtils.isFileExists(testFile)) {
                is = new FileInputStream(testFile);
            } else {
                is = BaseUtils.getApp().getAssets().open("emvcontactlesscfg.xml");
            }
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Element[] attributeItems = getElementsByName((Element)root.getElementsByTagName(EMV_CTLS_PAYPASS).item(0), "attribute");
                if (attributeItems == null || attributeItems.length == 0) {
                    throw new IOException("config error");
                }
                for (Element attribute : attributeItems){
                    hashMap.put(getElementAttr(attribute, "tag"), getElementAttr(attribute, "value"));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    public static HashMap<String, String> getCtlsCfgPaywave() {
        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
                "/emvcontactlesscfg.xml";
        InputStream is;
        HashMap<String, String> hashMap = new HashMap<>();
        try {
            // if testFile exists, load test file, or load from Assets
            if (FileUtils.isFileExists(testFile)) {
                is = new FileInputStream(testFile);
            } else {
                is = BaseUtils.getApp().getAssets().open("emvcontactlesscfg.xml");
            }
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Element[] attributeItems = getElementsByName((Element)root.getElementsByTagName(EMV_CTLS_PAYWAVE).item(0), "attribute");
                if (attributeItems == null || attributeItems.length == 0) {
                    throw new IOException("config error");
                }
                for (Element attribute : attributeItems){
                    hashMap.put(getElementAttr(attribute, "tag"), getElementAttr(attribute, "value"));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    public static void setCtlsCfgPaywavePaypass(String element, String tag, String value) {
        String testFile = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() +
                "/emvcontactlesscfg.xml";
        InputStream is;

        try {
            // if testFile exists, load test file, or load from Assets
            if (FileUtils.isFileExists(testFile)) {
                is = new FileInputStream(testFile);
            } else {
                is = BaseUtils.getApp().getAssets().open("emvcontactlesscfg.xml");
            }
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Element[] attributeItems = getElementsByName((Element)root.getElementsByTagName(element).item(0), "attribute");
                if (attributeItems == null || attributeItems.length == 0) {
                    throw new IOException("config error");
                }

                for (Element attribute : attributeItems){
                    if(getElementAttr(attribute, "tag").equals(tag)){
                        setElementAttr(attribute, "value", value);

                        TransformerFactory factory = TransformerFactory.newInstance();
                        Transformer former = factory.newTransformer();
                        former.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(testFile)));
                        break;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    @SuppressWarnings("ResultOfMethodCallIgnored")
    private static String readAssetsTxt(String fileName) {
        try {
            InputStream is = BaseUtils.getApp().getAssets().open(fileName);
            int size = is.available();
            // Read the entire asset into a local byte buffer.
            byte[] buffer = new byte[size];
            //noinspection ResultOfMethodCallIgnored
            is.read(buffer);
            is.close();
            // Convert the buffer into a string.
            return new String(buffer, "utf-8");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;

    }


    @SuppressWarnings("ResultOfMethodCallIgnored")
    private static String readFile(String filePath) {
        try {
            InputStream is = new FileInputStream(filePath);
            int size = is.available();
            // Read the entire asset into a local byte buffer.
            byte[] buffer = new byte[size];
            //noinspection ResultOfMethodCallIgnored
            is.read(buffer);
            is.close();
            // Convert the buffer into a string.
            return new String(buffer, "utf-8");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    private static String getElementAttr(Element element, String attr) {
        if (element == null) return "";
        if (element.hasAttribute(attr)) {
            return element.getAttribute(attr);
        }
        return "";
    }

    private static void setElementAttr(Element element, String attr, String value){
        if(element == null){
            return ;
        }
        if(!element.hasAttribute(attr)){
            return ;
        }
        element.setAttribute(attr, value);

    }

    private static Element[] getElementsByName(Element parent, String name) {
        ArrayList resList = new ArrayList();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); i++) {
            Node nd = nl.item(i);
            if (nd.getNodeName().equals(name)) {
                resList.add(nd);
            }
        }
        Element[] res = new Element[resList.size()];
        for (int i = 0; i < resList.size(); i++) {
            res[i] = (Element) resList.get(i);
        }
        return res;
    }

}
