package cn.nexgo.inbas.components.data.repository;

import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

import cn.nexgo.inbas.common.Constans.CardAcq;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.CardBinEntity;
import cn.nexgo.inbas.components.data.daoGenerate.CardBinEntityDao;
import cn.nexgo.inbas.components.data.daoGenerate.DaoSession;
import cn.nexgo.inbas.components.data.helper.SettingDbHelper;
import cn.nexgo.utils.AppLogUtils;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : CardBinRepository.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/4/11 
 * Modification  : Created file

 **************************************************************************************************/
public class CardBinRepository {
    private static String LOG_TAG = "CardBinRepository";
    private CardBinEntityDao recordEntityDao;
    private static volatile CardBinRepository INSTANCE;
    private CardBinRepository() {
        init();
    }
    public static CardBinRepository getInstance(){
        if (INSTANCE == null){
            synchronized (OperatorRepository.class){
                if (INSTANCE == null){
                    INSTANCE = new CardBinRepository();
                }
            }
        }
        return INSTANCE;
    }

    /**
     *  Initialize Entity Dao
     */
    private void init(){
        DaoSession daoSession = SettingDbHelper.getInstance().getDaoSession();
        recordEntityDao = daoSession.getCardBinEntityDao();
    }


    /**
     * Insert an Entity. If id is already existed, then update the existed record.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean insert(CardBinEntity entity) {
        if(entity == null){
            return false;
        }
        if (recordEntityDao == null){
            init();
        }

        recordEntityDao.insert(entity);
        return true;
    }

    /**
     * Delete an Entity
     * @param entity Entity
     * @return Success & fail
     */
    public boolean delete(CardBinEntity entity) {
        if(entity == null){
            return false;
        }
        if (recordEntityDao == null){
            init();
        }

        try{
            recordEntityDao.delete(entity);
        }catch (DaoException e){
            AppLogUtils.error(true, LOG_TAG,  "Delete failed throw Dao exception");
            return false;
        }

        return true;
    }

    /**
     * Delete Last Entity
     * @return Success & fail
     */
    public boolean deleteLast() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<CardBinEntity> qb = recordEntityDao.queryBuilder().orderDesc(CardBinEntityDao.Properties.Id).limit(1);    //invert list
        List<CardBinEntity> gotRecords = qb.build().list();      //Get Object List
        if (gotRecords == null || gotRecords.isEmpty()) {
            return true;
        }
        delete(gotRecords.get(0));
        return true;
    }

    /**
     * Delete All Entities
     */
    public void deleteAll() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.deleteAll();
    }

    /**
     * Get Last Entity
     * @return Entity
     */
    public CardBinEntity getLast() {
        if (recordEntityDao == null) {
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<CardBinEntity> qb = recordEntityDao.queryBuilder().orderDesc(CardBinEntityDao.Properties.Id).limit(1);    //invert list
        return qb.build().unique();
    }

    /**
     * Update an Entity. If id is not existed, insert a new entity.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean update(CardBinEntity entity) {
        if(entity == null){
            return false;
        }

        if (recordEntityDao == null){
            init();
        }

        recordEntityDao.update(entity);
        return true;
    }

    /**
     * Get Record Nunbers
     * @return Record Numbers
     */
    public int getRecordNum() {
        if (recordEntityDao == null){
            init();
        }
        AppLogUtils.trace(DataOpenHelper.LOG_ENABLE, LOG_TAG, "getRecordNum = "+ (int) recordEntityDao.count());
        return (int)recordEntityDao.count();
    }

    /**
     * get card acquirer by card number
     * @param cardNo
     * @return
     */
    public CardAcq getAcqByCardPrefix(String cardNo){
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        String str = FormatUtils.appendArray(cardNo, 19, false, '0');
        QueryBuilder<CardBinEntity> qb = recordEntityDao.queryBuilder();
        List<CardBinEntity> cardBinEntities = qb.where(CardBinEntityDao.Properties.StartPrefix.le(str),
                CardBinEntityDao.Properties.EndPrefix.ge(str)).limit(1).build().list();
        if (cardBinEntities != null && cardBinEntities.size() > 0){
            return cardBinEntities.get(0).getCardAcqEnum();
        }

        return CardAcq.UNKNOWN;
    }

}
