package cn.nexgo.inbas.components.data.helper;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import cn.nexgo.inbas.common.Constans.CardAcq;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.CardBinEntity;
import cn.nexgo.inbas.components.data.repository.CardBinRepository;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : CardBinHelper.java
 * Usage         :
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/4/12
 * Modification  : Created file

 **************************************************************************************************/

public final class CardBinHelper {

    public static void init() {
        CardBinRepository cardBinRepository = DataOpenHelper.getInstance().getCardBinRepository();
        try {
            InputStream is = BaseUtils.getApp().getAssets().open("cardbin.xml");
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Element[] attributeItems = getElementsByName(root, "attribute");
                if (attributeItems == null || attributeItems.length == 0) {
                    throw new IOException("config error");
                }
                // if count is same, does not need to refresh database
                if (cardBinRepository.getRecordNum() != attributeItems.length){
                    cardBinRepository.deleteAll();
                    for (Element attribute : attributeItems){
                        CardBinEntity cardBinEntity = new CardBinEntity();
                        String start = getElementAttr(attribute, "start");
                        cardBinEntity.setStartPrefix(FormatUtils.appendArray(start, 19, false, '0'));
                        String end = getElementAttr(attribute, "end");
                        if (end == null || end.equals("")){
                            end = start;
                        }
                        cardBinEntity.setEndPrefix(FormatUtils.appendArray(end, 19, false, '9'));
                        String name = getElementAttr(attribute, "name");
                        cardBinEntity.setCardAcq(getCardAcqByName(name));

                        cardBinRepository.insert(cardBinEntity);

                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



    private static String getElementAttr(Element element, String attr) {
        if (element == null) return "";
        if (element.hasAttribute(attr)) {
            return element.getAttribute(attr);
        }
        return "";
    }

    /**
     *
     * @param parent
     * @param name
     * @return
     */
    private static Element getElementByName(Element parent, String name, int index) {
        NodeList nl = parent.getChildNodes();
        if (index < nl.getLength()){
            Node node = nl.item(index);
            if (node.getNodeName().equals(name)) {
                return (Element)node;
            }
        }
        return null;

    }

    /**
     *
     * @param parent
     * @param name
     * @return
     */
    private static Element[] getElementsByName(Element parent, String name) {
        ArrayList resList = new ArrayList();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); i++) {
            Node nd = nl.item(i);
            if (nd.getNodeName().equals(name)) {
                resList.add(nd);
            }
        }
        Element[] res = new Element[resList.size()];
        for (int i = 0; i < resList.size(); i++) {
            res[i] = (Element) resList.get(i);
        }
        return res;
    }

    private static CardAcq getCardAcqByName(String name){
        switch (name){
            case "CUP":
                return CardAcq.CUP;
            case "MC":
                return CardAcq.MASTER;
            case "VISA":
                return CardAcq.VISA;
            case "AMEX":
                return CardAcq.AMEX;
            case "DISCOVER":
                return CardAcq.DISCOVER;
            case "JCB":
                return CardAcq.JCB;
            default:
                return CardAcq.UNKNOWN;
        }
    }
}