package cn.nexgo.inbas.components.data.daoGenerate;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import cn.nexgo.inbas.components.data.bean.SettleInfoEntity;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "SETTLEMENT_INFO_TABLE".
*/
public class SettleInfoEntityDao extends AbstractDao<SettleInfoEntity, Long> {

    public static final String TABLENAME = "SETTLEMENT_INFO_TABLE";

    /**
     * Properties of entity SettleInfoEntity.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property BatchStatus = new Property(1, int.class, "batchStatus", false, "BATCH_STATUS");
        public final static Property BatchUploadTotal = new Property(2, int.class, "batchUploadTotal", false, "BATCH_UPLOAD_NUM");
        public final static Property SettleStatus = new Property(3, int.class, "settleStatus", false, "SETTLE_STATUS");
        public final static Property MerchantID = new Property(4, String.class, "merchantID", false, "SETTLE_MID");
        public final static Property TerminalID = new Property(5, String.class, "terminalID", false, "SETTLE_TID");
        public final static Property BatchNO = new Property(6, String.class, "batchNO", false, "SETTLE_BATCH_NO");
        public final static Property DateTime = new Property(7, String.class, "dateTime", false, "SETTLE_DATE_TIME");
        public final static Property CashierNO = new Property(8, String.class, "cashierNO", false, "SETTLE_CAHSIER_NO");
        public final static Property IsBalanced = new Property(9, boolean.class, "isBalanced", false, "IS_BALANCED_NO_RMB");
        public final static Property TotalDebitNum = new Property(10, int.class, "totalDebitNum", false, "TOTAL_DEBIT_NUM_NO_RMB");
        public final static Property TotalDebitAmount = new Property(11, String.class, "totalDebitAmount", false, "TOTAL_DEBIT_AMOUNT_NO_RMB");
        public final static Property TotalCreditNum = new Property(12, int.class, "totalCreditNum", false, "TOTAL_CREDIT_NUM_NO_RMB");
        public final static Property TotalCreditAmount = new Property(13, String.class, "totalCreditAmount", false, "TOTAL_CREDIT_AMOUNT_NO_RMB");
        public final static Property TotalSaleNum = new Property(14, int.class, "totalSaleNum", false, "TOTAL_SALE_NUM_NO_RMB");
        public final static Property TotalSaleAmount = new Property(15, String.class, "totalSaleAmount", false, "TOTAL_SALE_AMOUNT_NO_RMB");
        public final static Property TotalVoidNum = new Property(16, int.class, "totalVoidNum", false, "TOTAL_VOID_NUM_NO_RMB");
        public final static Property TotalVoidAmount = new Property(17, String.class, "totalVoidAmount", false, "TOTAL_VOID_AMOUNT_NO_RMB");
        public final static Property TotalRefundNum = new Property(18, int.class, "totalRefundNum", false, "TOTAL_REFUND_NUM_NO_RMB");
        public final static Property TotalRefundAmount = new Property(19, String.class, "totalRefundAmount", false, "TOTAL_REFUND_AMOUNT_NO_RMB");
        public final static Property IsBalancedRMB = new Property(20, boolean.class, "isBalancedRMB", false, "IS_BALANCED_RMB");
        public final static Property TotalDebitNumRMB = new Property(21, int.class, "totalDebitNumRMB", false, "TOTAL_DEBIT_NUM_RMB");
        public final static Property TotalDebitAmountRMB = new Property(22, String.class, "totalDebitAmountRMB", false, "TOTAL_DEBIT_AMOUNT_RMB");
        public final static Property TotalCreditNumRMB = new Property(23, int.class, "totalCreditNumRMB", false, "TOTAL_CREDIT_NUM_RMB");
        public final static Property TotalCreditAmountRMB = new Property(24, String.class, "totalCreditAmountRMB", false, "TOTAL_CREDIT_AMOUNT_RMB");
        public final static Property TotalSaleNumRMB = new Property(25, int.class, "totalSaleNumRMB", false, "TOTAL_SALE_NUM_RMB");
        public final static Property TotalSaleAmountRMB = new Property(26, String.class, "totalSaleAmountRMB", false, "TOTAL_SALE_AMOUNT_RMB");
        public final static Property TotalVoidNumRMB = new Property(27, int.class, "totalVoidNumRMB", false, "TOTAL_VOID_NUM_RMB");
        public final static Property TotalVoidAmountRMB = new Property(28, String.class, "totalVoidAmountRMB", false, "TOTAL_VOID_AMOUNT_RMB");
        public final static Property TotalRefundNumRMB = new Property(29, int.class, "totalRefundNumRMB", false, "TOTAL_REFUND_NUM_RMB");
        public final static Property TotalRefundAmountRMB = new Property(30, String.class, "totalRefundAmountRMB", false, "TOTAL_REFUND_AMOUNT_RMB");
        public final static Property Rfu1 = new Property(31, String.class, "rfu1", false, "RFU_1");
        public final static Property Rfu2 = new Property(32, String.class, "rfu2", false, "RFU_2");
        public final static Property Rfu3 = new Property(33, String.class, "rfu3", false, "RFU_3");
    }


    public SettleInfoEntityDao(DaoConfig config) {
        super(config);
    }
    
    public SettleInfoEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"SETTLEMENT_INFO_TABLE\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"BATCH_STATUS\" INTEGER NOT NULL ," + // 1: batchStatus
                "\"BATCH_UPLOAD_NUM\" INTEGER NOT NULL ," + // 2: batchUploadTotal
                "\"SETTLE_STATUS\" INTEGER NOT NULL ," + // 3: settleStatus
                "\"SETTLE_MID\" TEXT," + // 4: merchantID
                "\"SETTLE_TID\" TEXT," + // 5: terminalID
                "\"SETTLE_BATCH_NO\" TEXT," + // 6: batchNO
                "\"SETTLE_DATE_TIME\" TEXT," + // 7: dateTime
                "\"SETTLE_CAHSIER_NO\" TEXT," + // 8: cashierNO
                "\"IS_BALANCED_NO_RMB\" INTEGER NOT NULL ," + // 9: isBalanced
                "\"TOTAL_DEBIT_NUM_NO_RMB\" INTEGER NOT NULL ," + // 10: totalDebitNum
                "\"TOTAL_DEBIT_AMOUNT_NO_RMB\" TEXT," + // 11: totalDebitAmount
                "\"TOTAL_CREDIT_NUM_NO_RMB\" INTEGER NOT NULL ," + // 12: totalCreditNum
                "\"TOTAL_CREDIT_AMOUNT_NO_RMB\" TEXT," + // 13: totalCreditAmount
                "\"TOTAL_SALE_NUM_NO_RMB\" INTEGER NOT NULL ," + // 14: totalSaleNum
                "\"TOTAL_SALE_AMOUNT_NO_RMB\" TEXT," + // 15: totalSaleAmount
                "\"TOTAL_VOID_NUM_NO_RMB\" INTEGER NOT NULL ," + // 16: totalVoidNum
                "\"TOTAL_VOID_AMOUNT_NO_RMB\" TEXT," + // 17: totalVoidAmount
                "\"TOTAL_REFUND_NUM_NO_RMB\" INTEGER NOT NULL ," + // 18: totalRefundNum
                "\"TOTAL_REFUND_AMOUNT_NO_RMB\" TEXT," + // 19: totalRefundAmount
                "\"IS_BALANCED_RMB\" INTEGER NOT NULL ," + // 20: isBalancedRMB
                "\"TOTAL_DEBIT_NUM_RMB\" INTEGER NOT NULL ," + // 21: totalDebitNumRMB
                "\"TOTAL_DEBIT_AMOUNT_RMB\" TEXT," + // 22: totalDebitAmountRMB
                "\"TOTAL_CREDIT_NUM_RMB\" INTEGER NOT NULL ," + // 23: totalCreditNumRMB
                "\"TOTAL_CREDIT_AMOUNT_RMB\" TEXT," + // 24: totalCreditAmountRMB
                "\"TOTAL_SALE_NUM_RMB\" INTEGER NOT NULL ," + // 25: totalSaleNumRMB
                "\"TOTAL_SALE_AMOUNT_RMB\" TEXT," + // 26: totalSaleAmountRMB
                "\"TOTAL_VOID_NUM_RMB\" INTEGER NOT NULL ," + // 27: totalVoidNumRMB
                "\"TOTAL_VOID_AMOUNT_RMB\" TEXT," + // 28: totalVoidAmountRMB
                "\"TOTAL_REFUND_NUM_RMB\" INTEGER NOT NULL ," + // 29: totalRefundNumRMB
                "\"TOTAL_REFUND_AMOUNT_RMB\" TEXT," + // 30: totalRefundAmountRMB
                "\"RFU_1\" TEXT," + // 31: rfu1
                "\"RFU_2\" TEXT," + // 32: rfu2
                "\"RFU_3\" TEXT);"); // 33: rfu3
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"SETTLEMENT_INFO_TABLE\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, SettleInfoEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getBatchStatus());
        stmt.bindLong(3, entity.getBatchUploadTotal());
        stmt.bindLong(4, entity.getSettleStatus());
 
        String merchantID = entity.getMerchantID();
        if (merchantID != null) {
            stmt.bindString(5, merchantID);
        }
 
        String terminalID = entity.getTerminalID();
        if (terminalID != null) {
            stmt.bindString(6, terminalID);
        }
 
        String batchNO = entity.getBatchNO();
        if (batchNO != null) {
            stmt.bindString(7, batchNO);
        }
 
        String dateTime = entity.getDateTime();
        if (dateTime != null) {
            stmt.bindString(8, dateTime);
        }
 
        String cashierNO = entity.getCashierNO();
        if (cashierNO != null) {
            stmt.bindString(9, cashierNO);
        }
        stmt.bindLong(10, entity.getIsBalanced() ? 1L: 0L);
        stmt.bindLong(11, entity.getTotalDebitNum());
 
        String totalDebitAmount = entity.getTotalDebitAmount();
        if (totalDebitAmount != null) {
            stmt.bindString(12, totalDebitAmount);
        }
        stmt.bindLong(13, entity.getTotalCreditNum());
 
        String totalCreditAmount = entity.getTotalCreditAmount();
        if (totalCreditAmount != null) {
            stmt.bindString(14, totalCreditAmount);
        }
        stmt.bindLong(15, entity.getTotalSaleNum());
 
        String totalSaleAmount = entity.getTotalSaleAmount();
        if (totalSaleAmount != null) {
            stmt.bindString(16, totalSaleAmount);
        }
        stmt.bindLong(17, entity.getTotalVoidNum());
 
        String totalVoidAmount = entity.getTotalVoidAmount();
        if (totalVoidAmount != null) {
            stmt.bindString(18, totalVoidAmount);
        }
        stmt.bindLong(19, entity.getTotalRefundNum());
 
        String totalRefundAmount = entity.getTotalRefundAmount();
        if (totalRefundAmount != null) {
            stmt.bindString(20, totalRefundAmount);
        }
        stmt.bindLong(21, entity.getIsBalancedRMB() ? 1L: 0L);
        stmt.bindLong(22, entity.getTotalDebitNumRMB());
 
        String totalDebitAmountRMB = entity.getTotalDebitAmountRMB();
        if (totalDebitAmountRMB != null) {
            stmt.bindString(23, totalDebitAmountRMB);
        }
        stmt.bindLong(24, entity.getTotalCreditNumRMB());
 
        String totalCreditAmountRMB = entity.getTotalCreditAmountRMB();
        if (totalCreditAmountRMB != null) {
            stmt.bindString(25, totalCreditAmountRMB);
        }
        stmt.bindLong(26, entity.getTotalSaleNumRMB());
 
        String totalSaleAmountRMB = entity.getTotalSaleAmountRMB();
        if (totalSaleAmountRMB != null) {
            stmt.bindString(27, totalSaleAmountRMB);
        }
        stmt.bindLong(28, entity.getTotalVoidNumRMB());
 
        String totalVoidAmountRMB = entity.getTotalVoidAmountRMB();
        if (totalVoidAmountRMB != null) {
            stmt.bindString(29, totalVoidAmountRMB);
        }
        stmt.bindLong(30, entity.getTotalRefundNumRMB());
 
        String totalRefundAmountRMB = entity.getTotalRefundAmountRMB();
        if (totalRefundAmountRMB != null) {
            stmt.bindString(31, totalRefundAmountRMB);
        }
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(32, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(33, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(34, rfu3);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, SettleInfoEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getBatchStatus());
        stmt.bindLong(3, entity.getBatchUploadTotal());
        stmt.bindLong(4, entity.getSettleStatus());
 
        String merchantID = entity.getMerchantID();
        if (merchantID != null) {
            stmt.bindString(5, merchantID);
        }
 
        String terminalID = entity.getTerminalID();
        if (terminalID != null) {
            stmt.bindString(6, terminalID);
        }
 
        String batchNO = entity.getBatchNO();
        if (batchNO != null) {
            stmt.bindString(7, batchNO);
        }
 
        String dateTime = entity.getDateTime();
        if (dateTime != null) {
            stmt.bindString(8, dateTime);
        }
 
        String cashierNO = entity.getCashierNO();
        if (cashierNO != null) {
            stmt.bindString(9, cashierNO);
        }
        stmt.bindLong(10, entity.getIsBalanced() ? 1L: 0L);
        stmt.bindLong(11, entity.getTotalDebitNum());
 
        String totalDebitAmount = entity.getTotalDebitAmount();
        if (totalDebitAmount != null) {
            stmt.bindString(12, totalDebitAmount);
        }
        stmt.bindLong(13, entity.getTotalCreditNum());
 
        String totalCreditAmount = entity.getTotalCreditAmount();
        if (totalCreditAmount != null) {
            stmt.bindString(14, totalCreditAmount);
        }
        stmt.bindLong(15, entity.getTotalSaleNum());
 
        String totalSaleAmount = entity.getTotalSaleAmount();
        if (totalSaleAmount != null) {
            stmt.bindString(16, totalSaleAmount);
        }
        stmt.bindLong(17, entity.getTotalVoidNum());
 
        String totalVoidAmount = entity.getTotalVoidAmount();
        if (totalVoidAmount != null) {
            stmt.bindString(18, totalVoidAmount);
        }
        stmt.bindLong(19, entity.getTotalRefundNum());
 
        String totalRefundAmount = entity.getTotalRefundAmount();
        if (totalRefundAmount != null) {
            stmt.bindString(20, totalRefundAmount);
        }
        stmt.bindLong(21, entity.getIsBalancedRMB() ? 1L: 0L);
        stmt.bindLong(22, entity.getTotalDebitNumRMB());
 
        String totalDebitAmountRMB = entity.getTotalDebitAmountRMB();
        if (totalDebitAmountRMB != null) {
            stmt.bindString(23, totalDebitAmountRMB);
        }
        stmt.bindLong(24, entity.getTotalCreditNumRMB());
 
        String totalCreditAmountRMB = entity.getTotalCreditAmountRMB();
        if (totalCreditAmountRMB != null) {
            stmt.bindString(25, totalCreditAmountRMB);
        }
        stmt.bindLong(26, entity.getTotalSaleNumRMB());
 
        String totalSaleAmountRMB = entity.getTotalSaleAmountRMB();
        if (totalSaleAmountRMB != null) {
            stmt.bindString(27, totalSaleAmountRMB);
        }
        stmt.bindLong(28, entity.getTotalVoidNumRMB());
 
        String totalVoidAmountRMB = entity.getTotalVoidAmountRMB();
        if (totalVoidAmountRMB != null) {
            stmt.bindString(29, totalVoidAmountRMB);
        }
        stmt.bindLong(30, entity.getTotalRefundNumRMB());
 
        String totalRefundAmountRMB = entity.getTotalRefundAmountRMB();
        if (totalRefundAmountRMB != null) {
            stmt.bindString(31, totalRefundAmountRMB);
        }
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(32, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(33, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(34, rfu3);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public SettleInfoEntity readEntity(Cursor cursor, int offset) {
        SettleInfoEntity entity = new SettleInfoEntity( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getInt(offset + 1), // batchStatus
            cursor.getInt(offset + 2), // batchUploadTotal
            cursor.getInt(offset + 3), // settleStatus
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // merchantID
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // terminalID
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // batchNO
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // dateTime
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // cashierNO
            cursor.getShort(offset + 9) != 0, // isBalanced
            cursor.getInt(offset + 10), // totalDebitNum
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // totalDebitAmount
            cursor.getInt(offset + 12), // totalCreditNum
            cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13), // totalCreditAmount
            cursor.getInt(offset + 14), // totalSaleNum
            cursor.isNull(offset + 15) ? null : cursor.getString(offset + 15), // totalSaleAmount
            cursor.getInt(offset + 16), // totalVoidNum
            cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17), // totalVoidAmount
            cursor.getInt(offset + 18), // totalRefundNum
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // totalRefundAmount
            cursor.getShort(offset + 20) != 0, // isBalancedRMB
            cursor.getInt(offset + 21), // totalDebitNumRMB
            cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22), // totalDebitAmountRMB
            cursor.getInt(offset + 23), // totalCreditNumRMB
            cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24), // totalCreditAmountRMB
            cursor.getInt(offset + 25), // totalSaleNumRMB
            cursor.isNull(offset + 26) ? null : cursor.getString(offset + 26), // totalSaleAmountRMB
            cursor.getInt(offset + 27), // totalVoidNumRMB
            cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28), // totalVoidAmountRMB
            cursor.getInt(offset + 29), // totalRefundNumRMB
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // totalRefundAmountRMB
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // rfu1
            cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32), // rfu2
            cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33) // rfu3
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, SettleInfoEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setBatchStatus(cursor.getInt(offset + 1));
        entity.setBatchUploadTotal(cursor.getInt(offset + 2));
        entity.setSettleStatus(cursor.getInt(offset + 3));
        entity.setMerchantID(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setTerminalID(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setBatchNO(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setDateTime(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setCashierNO(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setIsBalanced(cursor.getShort(offset + 9) != 0);
        entity.setTotalDebitNum(cursor.getInt(offset + 10));
        entity.setTotalDebitAmount(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setTotalCreditNum(cursor.getInt(offset + 12));
        entity.setTotalCreditAmount(cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13));
        entity.setTotalSaleNum(cursor.getInt(offset + 14));
        entity.setTotalSaleAmount(cursor.isNull(offset + 15) ? null : cursor.getString(offset + 15));
        entity.setTotalVoidNum(cursor.getInt(offset + 16));
        entity.setTotalVoidAmount(cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17));
        entity.setTotalRefundNum(cursor.getInt(offset + 18));
        entity.setTotalRefundAmount(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setIsBalancedRMB(cursor.getShort(offset + 20) != 0);
        entity.setTotalDebitNumRMB(cursor.getInt(offset + 21));
        entity.setTotalDebitAmountRMB(cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22));
        entity.setTotalCreditNumRMB(cursor.getInt(offset + 23));
        entity.setTotalCreditAmountRMB(cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24));
        entity.setTotalSaleNumRMB(cursor.getInt(offset + 25));
        entity.setTotalSaleAmountRMB(cursor.isNull(offset + 26) ? null : cursor.getString(offset + 26));
        entity.setTotalVoidNumRMB(cursor.getInt(offset + 27));
        entity.setTotalVoidAmountRMB(cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28));
        entity.setTotalRefundNumRMB(cursor.getInt(offset + 29));
        entity.setTotalRefundAmountRMB(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setRfu1(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setRfu2(cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32));
        entity.setRfu3(cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(SettleInfoEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(SettleInfoEntity entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(SettleInfoEntity entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
