package cn.nexgo.inbas.components.data.daoGenerate;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import cn.nexgo.inbas.components.data.bean.OperatorEntity;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "OPERATOR_TABLE".
*/
public class OperatorEntityDao extends AbstractDao<OperatorEntity, Long> {

    public static final String TABLENAME = "OPERATOR_TABLE";

    /**
     * Properties of entity OperatorEntity.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property OperatorNo = new Property(1, String.class, "operatorNo", false, "OPERATOR_NO");
        public final static Property Password = new Property(2, String.class, "password", false, "PASSWORD");
        public final static Property Rfu1 = new Property(3, String.class, "rfu1", false, "RFU_1");
        public final static Property Rfu2 = new Property(4, String.class, "rfu2", false, "RFU_2");
        public final static Property Rfu3 = new Property(5, String.class, "rfu3", false, "RFU_3");
    }


    public OperatorEntityDao(DaoConfig config) {
        super(config);
    }
    
    public OperatorEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"OPERATOR_TABLE\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"OPERATOR_NO\" TEXT NOT NULL ," + // 1: operatorNo
                "\"PASSWORD\" TEXT NOT NULL ," + // 2: password
                "\"RFU_1\" TEXT," + // 3: rfu1
                "\"RFU_2\" TEXT," + // 4: rfu2
                "\"RFU_3\" TEXT);"); // 5: rfu3
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"OPERATOR_TABLE\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, OperatorEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getOperatorNo());
        stmt.bindString(3, entity.getPassword());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(4, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(5, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(6, rfu3);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, OperatorEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindString(2, entity.getOperatorNo());
        stmt.bindString(3, entity.getPassword());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(4, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(5, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(6, rfu3);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public OperatorEntity readEntity(Cursor cursor, int offset) {
        OperatorEntity entity = new OperatorEntity( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getString(offset + 1), // operatorNo
            cursor.getString(offset + 2), // password
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // rfu1
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // rfu2
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5) // rfu3
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, OperatorEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setOperatorNo(cursor.getString(offset + 1));
        entity.setPassword(cursor.getString(offset + 2));
        entity.setRfu1(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setRfu2(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setRfu3(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(OperatorEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(OperatorEntity entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(OperatorEntity entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
