package cn.nexgo.inbas.components.data.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;

import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.components.data.DataConstant.CtlsFlowType;
import cn.nexgo.inbas.components.data.DataConstant.ReversalReason;
import cn.nexgo.inbas.controller.global.TransType;
import cn.nexgo.utils.ConvertUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : TransRecordEntity.java
 * Usage         : Entity for a Transaction Entity
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/11
 * Modification  : Created file

 **************************************************************************************************/
@Entity(

        nameInDb = "TRANS_DATA_RECORD",// Table Name
        createInDb = true,             // if create a tablE
        generateConstructors = true,   // if generate constructors.
        generateGettersSetters = true  // If generate getters and setters' methods
)
public class TransRecordEntity {
    @Id(autoincrement = true)
    private Long id;                            // Unique id for each record

    //Transaction ID
    @NotNull
    @Property(nameInDb = "TRANS_ID")
    private int transID;

    //Card Information
    @Property(nameInDb = "CARD_Type")
    private int cardType;                           // card reading mode: manual, magstripe, contact, contactless
    @Property(nameInDb = "CARD_CTLS_FLOW_TYPE")
    private int cardCtlsFlowType;                   // contactless EMV flow type: PBOC contactless, QPBOC, MSD-contactless
    @Property(nameInDb = "CARD_FALLBACK")
    private boolean cardFallback;                   // if it is Fallback
    @Property(nameInDb = "CARD_NO")
    private String cardNo;                          // card number  (Encrypted)
    @Property(nameInDb = "CARD_HOLDER_NAME")
    private String cardHolderName;                  // card holder name (Encrypted)
    @Property(nameInDb = "CARD_EXP_DATE")
    private String cardExpDate;                     // card expired date (Encrypted) 

    //EMV Information
    @Property(nameInDb = "EMV_AC")
    private String emvAC;                          //Tag 9F26(M): Application Cryptogram
    @Property(nameInDb = "EMV_CID")
    private String emvCID;                         //Tag 9F27(M): Cryptogram Info Data
    @Property(nameInDb = "EMV_IAD")
    private String emvIAD;                         //Tag 9F10(M): Issuer Application Data
    @Property(nameInDb = "EMV_UN")
    private String emvUN;                          //Tag 9F37(M): Unpredictable Number
    @Property(nameInDb = "EMV_ATC")
    private String emvATC;                         //Tag 9F36(M): Application Transaction Counter
    @Property(nameInDb = "EMV_TVR")
    private String emvTVR;                         //Tag 95  (M): Terminal Verification Results
    @Property(nameInDb = "EMV_TRANS_DATE")
    private String emvTransDate;                   //Tag 9A  (M): Transaction Date
    @Property(nameInDb = "EMV_TRANS_TYPE")
    private String emvTransType;                   //Tag 9C  (M): Transaction Type, Length(1 byte)
    @Property(nameInDb = "EMV_TRANS_AMOUNT")
    private String emvTransAmount;                 //Tag 9F02(M): Transaction Amount
    @Property(nameInDb = "EMV_CURRENCY_CODE")
    private String emvCurrencyCode;                //Tag 5F2A(M): Transaction Currency Code
    @Property(nameInDb = "EMV_COUNTRY_CODE")
    private String emvCountryCode;                 //Tag 9F1A(M): Terminal Country Code
    @Property(nameInDb = "EMV_AIP")
    private String emvAIP;                         //Tag 82  (M): Application Interchange Profile
    @Property(nameInDb = "EMV_TERM_CAP")
    private String emvTermCap;                     //Tag 9F33(M): Terminal Capabilities
    @Property(nameInDb = "EMV_CVM_RESULT")
    private String emvCVMResult;                   //Tag 9F34(M): CVM Results
    @Property(nameInDb = "EMV_AMOUNT_OTHER")
    private String emvAmountOther;                 //Tag 9F03(O): Amount Other
    @Property(nameInDb = "EMV_AID")
    private String emvAID;                         //Tag 84  (O): Dedicated File Name/Application ID
    @Property(nameInDb = "EMV_APP_VERSION")
    private String emvAppVer;                      //Tag 9F08(O): Application Version Number
    @Property(nameInDb = "EMV_TERM_APP_VER")
    private String emvTermAppVer;                  //Tag 9F09(O): Terminal Application Version Number
    @Property(nameInDb = "EMV_TERM_TYPE")
    private String emvTermType;                    //Tag 9F35(O): Terminal Type: Length(1 byte)
    @Property(nameInDb = "EMV_IFD_SN")
    private String emvIFDSN;                       //Tag 9F1E(O): IFD Serial Number
    @Property(nameInDb = "EMV_CATEGORY_CODE")
    private String emvCategoryCode;                //Tag 9F53(O): Transaction Category Code: Length(1 byte)
    @Property(nameInDb = "EMV_TRANS_SEQ_CNT")
    private String emvTransSeqCnt;                 //Tag 9F41(O): Transaction Sequence Counter
    @Property(nameInDb = "EMV_FFI")
    private String emvFFI;                         //Tag 9F6E(O): Form Factor Indicator
    @Property(nameInDb = "EMV_IDN")
    private String emvIDN;                         //Tag 9F4C(O): ICC Dynamic Number
    @Property(nameInDb = "EMV_AOSA")
    private String emvAOSA;                        //Tag 9F5D(O): Available Offline Spending Amount
    @Property(nameInDb = "EMV_TSI")
    private String emvTSI;                         //Tag 9B  (O): Transaction Status Information
    @Property(nameInDb = "EMV_PAN_SN")
    private String emvPanSN;                       //Tag 5F34(O): Application PAN Sequence Number: Length(1 byte)
    @Property(nameInDb = "EMV_APP_LABEL")
    private String emvAppLabel;                    //Tag 50  (O): Application Label
    @Property(nameInDb = "EMV_APP_PREFER_NAME")
    private String emvAppPreferName;               //Tag 9F12(O): Application Preferred Name
    @Property(nameInDb = "EMV_AUTH_DATA")
    private String emvIssAuthData;                 //Tag 91    : Issuer Authentication Data
    @Property(nameInDb = "EMV_SCRIPT_DATA")
    private String emvScriptResult;                //Tag DF31  : issuer script 71/72 result
    @Property(nameInDb = "EMV_CARD_ID")
    private String emvCardId;                      //Tag 9F63  : card product ID

    //Transaciton Message Data
    @Property(nameInDb = "MSG_CASHIER_NO")
    private String msgCashierNO;                   // Cashier NO.

    /* request message */
    @Property(nameInDb = "MSG_BITMAP")
    private String msgBitmap;                      // #xx msgBitmap, 8 or 16 bytes, up to 128 fields
    // #02 PAN: same as cardNo
    @Property(nameInDb = "MSG_PROC_CODE")
    private String msgProcCode;                    // #03 Processing Code
    @Property(nameInDb = "MSG_AMOUNT")
    private String msgAmount;                      // #04 Amount
    @Property(nameInDb = "MSG_DATE_TIME")
    private String msgDateTime;                    // #07 Transmission Date & Time
    @Property(nameInDb = "MSG_TRACE_NO")
    private String msgTraceNO;                     // #11 System Trace Audit Number
    // #14 Expiration Date: same as cardExpDate
    @Property(nameInDb = "ENTRY_MODE")
    private String msgEntryMode;                   // #22 Point of Service Entry Mode
    // #23 Card Sequence Number, same as emvPanSN
    @Property(nameInDb = "MSG_CONDITION_CODE")
    private String msgConditionCode;               // #25 Point of Service Condition Code
    @Property(nameInDb = "MSG_PIN_CAP_CODE")
    private String msgPinCapCode;                  // #26 PIN Capture Code
    // #35 Track-2 Data
    // #36 Track-3 Data
    @Property(nameInDb = "MSG_TERMINAL_ID")
    private String msgTermID;                      // #41 Card Acceptor Terminal ID(TID)
    @Property(nameInDb = "MSG_MERCHANT_ID")
    private String msgMerchID;                     // #42 Card Acceptor Identification Code(MID)
    // #45 Track-1 Data
    @Property(nameInDb = "MSG_TIP_AMOUNT")
    private String msgTipAmount;                   // #48/#54 Additional Data – Private: TIP Amount
    @Property(nameInDb = "MSG_CURRENCY_CODE")
    private String msgCurrencyCode;                // #49 Transaction Currency Code
    // #55 ICC-Related Data: get data from stEmvInfo
    @Property(nameInDb = "MSG_FUNC_CODE")
    private String msgFuncCode;                    // #60.1 Function Number
    @Property(nameInDb = "MSG_BATCH_NO")
    private String msgBatchNO;                     // #60.2 System batch Number
    @Property(nameInDb = "MSG_ORG_BATCH_NO")
    private String msgOrigBatchNO;                 // #61.1 original System batch Number
    @Property(nameInDb = "MSG_ORG_TRACE_NO")
    private String msgOrigTraceNO;                 // #61.2 original System Trace Audit Number
    @Property(nameInDb = "MSG_ORG_DATE")
    private String msgOrigDate;                    // #61.3 original transaction date
    @Property(nameInDb = "MSG_CASHBACK_AMOUNT")
    private String msgCashbackAmount;              // #xx: cashback msgAmount

    /* response message */
    @Property(nameInDb = "MSG_TRANS_TIME")
    private String msgTransTime;                   // #12 Local Transaction Time
    @Property(nameInDb = "MSG_TRANS_DATE")
    private String msgTransDate;                   // #13 Local Transaction Date
    @Property(nameInDb = "MSG_SETTLEMENT_DATE")
    private String msgSettlementDate;              // #15 Date Of Settlement
    @Property(nameInDb = "MSG_ACQ_ID")
    private String msgAcqID;                        // #32 Acquiring Institution ID Code
    @Property(nameInDb = "MSG_REF_NO")
    private String msgRefNO;                       // #37 Retrieval Ref. Number
    @Property(nameInDb = "MSG_AUTH_CODE")
    private String msgAuthCode;                    // #38 Authorisation Identification Res
    @Property(nameInDb = "MSG_RESP_CODE")
    private String msgRespCode;                    // #39 response code
    @Property(nameInDb = "MSG_ISSUER_CODE")
    private String msgIssuerCode;                  // #44 Additional Response Data - Issuer code
    @Property(nameInDb = "MSG_ACQ_CODE")
    private String msgAcquirerCode;                // #44 Additional Response Data - Acquirer code
    @Property(nameInDb = "MSG_BALANCE")
    private String msgBalance;                     // #54 Additional Amounts

    @Property(nameInDb = "MSG_INTER_ORG_CODE")
    private String msgInterOrgCode;                // #63.1 International Organization code
    @Property(nameInDb = "MSG_ISSUER_INFO")
    private String msgIssuerInfo;                  // #63.2.1 Issuer info
    @Property(nameInDb = "MSG_CUP_INFO")
    private String msgCUPInfo;                     // #63.2.2 CUP info
    @Property(nameInDb = "MSG_ACQ_INFO")
    private String msgAcqInfo;                     // #63.2.3 acquirer info
    @Property(nameInDb = "MSG_TERM_RESERVED")
    private String msgTermReserved;                // #63.2.4

    //Transaction Status
    @Property(nameInDb = "STATUS_IS_FAILED_TRANS")
    private boolean statusIccFailTrans = false;            // Failed ICC transaction or not
    @Property(nameInDb = "STATUS_IS_OFFLINE")
    private boolean statusOffline = false;                 // Offline transaction or not
    @Property(nameInDb = "STATUS_IS_VOIDED")
    private boolean statusVoided = false;                  // have been statusVoided or not
    @Property(nameInDb = "STATUS_IS_ADJUSTED")
    private boolean statusAdjusted = false;                // have been statusAdjusted or not
    @Property(nameInDb = "STATUS_IS_NEED_REPRINT")
    private boolean statusNeedPrint = false;                // need print or not
    @Property(nameInDb = "STATUS_IS_NEED_REVERSAL")
    private boolean statusNeedReversal = false;            // need reversal or not
    @Property(nameInDb = "STATUS_IS_NEED_SCRIPT")
    private boolean statusNeedScript = false;              // need send script resault or not
    @Property(nameInDb = "STATUS_IS_APRC_ERR")
    private boolean statusArpcErr = false;                 // online approve but ARPC error
    @Property(nameInDb = "STATUS_REVERSAL_REASON")
    private int statusReversalReason = 0;                  // reversal reason
    @Property(nameInDb = "STATUS_ADJUSTED_TIMES")
    private int statusAdjustedTimes = 0;                   // how many times the transaction has been Adjusted
    @Property(nameInDb = "STATUS_OFFLINE_UPLOAD")
    private int statusOffineUpload = 0;                    // Offline transaction upload status
    @Property(nameInDb = "STATUS_BATCH_UPLOAD")
    private int statusBatchUpload = 0;                     // Batch upload status

    
    @Property(nameInDb = "RFU_1")
    private String rfu1;
    @Property(nameInDb = "RFU_2")
    private String rfu2;
    @Property(nameInDb = "RFU_3")
    private String rfu3;
//    @Property(nameInDb = "RFU_4")
//    private String rfu4;


    @Generated(hash = 459456087)
    public TransRecordEntity(Long id, int transID, int cardType, int cardCtlsFlowType, boolean cardFallback, String cardNo, String cardHolderName,
            String cardExpDate, String emvAC, String emvCID, String emvIAD, String emvUN, String emvATC, String emvTVR, String emvTransDate, String emvTransType,
            String emvTransAmount, String emvCurrencyCode, String emvCountryCode, String emvAIP, String emvTermCap, String emvCVMResult, String emvAmountOther,
            String emvAID, String emvAppVer, String emvTermAppVer, String emvTermType, String emvIFDSN, String emvCategoryCode, String emvTransSeqCnt,
            String emvFFI, String emvIDN, String emvAOSA, String emvTSI, String emvPanSN, String emvAppLabel, String emvAppPreferName, String emvIssAuthData,
            String emvScriptResult, String emvCardId, String msgCashierNO, String msgBitmap, String msgProcCode, String msgAmount, String msgDateTime,
            String msgTraceNO, String msgEntryMode, String msgConditionCode, String msgPinCapCode, String msgTermID, String msgMerchID, String msgTipAmount,
            String msgCurrencyCode, String msgFuncCode, String msgBatchNO, String msgOrigBatchNO, String msgOrigTraceNO, String msgOrigDate,
            String msgCashbackAmount, String msgTransTime, String msgTransDate, String msgSettlementDate, String msgAcqID, String msgRefNO, String msgAuthCode,
            String msgRespCode, String msgIssuerCode, String msgAcquirerCode, String msgBalance, String msgInterOrgCode, String msgIssuerInfo, String msgCUPInfo,
            String msgAcqInfo, String msgTermReserved, boolean statusIccFailTrans, boolean statusOffline, boolean statusVoided, boolean statusAdjusted,
            boolean statusNeedPrint, boolean statusNeedReversal, boolean statusNeedScript, boolean statusArpcErr, int statusReversalReason, int statusAdjustedTimes,
            int statusOffineUpload, int statusBatchUpload, String rfu1, String rfu2, String rfu3) {
        this.id = id;
        this.transID = transID;
        this.cardType = cardType;
        this.cardCtlsFlowType = cardCtlsFlowType;
        this.cardFallback = cardFallback;
        this.cardNo = cardNo;
        this.cardHolderName = cardHolderName;
        this.cardExpDate = cardExpDate;
        this.emvAC = emvAC;
        this.emvCID = emvCID;
        this.emvIAD = emvIAD;
        this.emvUN = emvUN;
        this.emvATC = emvATC;
        this.emvTVR = emvTVR;
        this.emvTransDate = emvTransDate;
        this.emvTransType = emvTransType;
        this.emvTransAmount = emvTransAmount;
        this.emvCurrencyCode = emvCurrencyCode;
        this.emvCountryCode = emvCountryCode;
        this.emvAIP = emvAIP;
        this.emvTermCap = emvTermCap;
        this.emvCVMResult = emvCVMResult;
        this.emvAmountOther = emvAmountOther;
        this.emvAID = emvAID;
        this.emvAppVer = emvAppVer;
        this.emvTermAppVer = emvTermAppVer;
        this.emvTermType = emvTermType;
        this.emvIFDSN = emvIFDSN;
        this.emvCategoryCode = emvCategoryCode;
        this.emvTransSeqCnt = emvTransSeqCnt;
        this.emvFFI = emvFFI;
        this.emvIDN = emvIDN;
        this.emvAOSA = emvAOSA;
        this.emvTSI = emvTSI;
        this.emvPanSN = emvPanSN;
        this.emvAppLabel = emvAppLabel;
        this.emvAppPreferName = emvAppPreferName;
        this.emvIssAuthData = emvIssAuthData;
        this.emvScriptResult = emvScriptResult;
        this.emvCardId = emvCardId;
        this.msgCashierNO = msgCashierNO;
        this.msgBitmap = msgBitmap;
        this.msgProcCode = msgProcCode;
        this.msgAmount = msgAmount;
        this.msgDateTime = msgDateTime;
        this.msgTraceNO = msgTraceNO;
        this.msgEntryMode = msgEntryMode;
        this.msgConditionCode = msgConditionCode;
        this.msgPinCapCode = msgPinCapCode;
        this.msgTermID = msgTermID;
        this.msgMerchID = msgMerchID;
        this.msgTipAmount = msgTipAmount;
        this.msgCurrencyCode = msgCurrencyCode;
        this.msgFuncCode = msgFuncCode;
        this.msgBatchNO = msgBatchNO;
        this.msgOrigBatchNO = msgOrigBatchNO;
        this.msgOrigTraceNO = msgOrigTraceNO;
        this.msgOrigDate = msgOrigDate;
        this.msgCashbackAmount = msgCashbackAmount;
        this.msgTransTime = msgTransTime;
        this.msgTransDate = msgTransDate;
        this.msgSettlementDate = msgSettlementDate;
        this.msgAcqID = msgAcqID;
        this.msgRefNO = msgRefNO;
        this.msgAuthCode = msgAuthCode;
        this.msgRespCode = msgRespCode;
        this.msgIssuerCode = msgIssuerCode;
        this.msgAcquirerCode = msgAcquirerCode;
        this.msgBalance = msgBalance;
        this.msgInterOrgCode = msgInterOrgCode;
        this.msgIssuerInfo = msgIssuerInfo;
        this.msgCUPInfo = msgCUPInfo;
        this.msgAcqInfo = msgAcqInfo;
        this.msgTermReserved = msgTermReserved;
        this.statusIccFailTrans = statusIccFailTrans;
        this.statusOffline = statusOffline;
        this.statusVoided = statusVoided;
        this.statusAdjusted = statusAdjusted;
        this.statusNeedPrint = statusNeedPrint;
        this.statusNeedReversal = statusNeedReversal;
        this.statusNeedScript = statusNeedScript;
        this.statusArpcErr = statusArpcErr;
        this.statusReversalReason = statusReversalReason;
        this.statusAdjustedTimes = statusAdjustedTimes;
        this.statusOffineUpload = statusOffineUpload;
        this.statusBatchUpload = statusBatchUpload;
        this.rfu1 = rfu1;
        this.rfu2 = rfu2;
        this.rfu3 = rfu3;
    }

    @Generated(hash = 308571091)
    public TransRecordEntity() {
    }


    /**
     * Add more Getters and Setters for users
     */
    public byte[] getEmvACByte() {
        return ConvertUtils.hexString2Bytes(this.emvAC);
    }

    public void setEmvAC(byte[] AC) {
        this.emvAC = ConvertUtils.bytes2HexString(AC, null);
    }

    public byte[] getEmvIADByte() {
        return ConvertUtils.hexString2Bytes(this.emvIAD);
    }

    public void setEmvIAD(byte[] IAD) {
        this.emvIAD = ConvertUtils.bytes2HexString(IAD, null);
    }

    public byte[] getEmvUNByte() {
        return ConvertUtils.hexString2Bytes(this.emvUN);
    }

    public void setEmvUN(byte[] UN) {
        this.emvUN = ConvertUtils.bytes2HexString(UN, null);
    }

    public byte[] getEmvATCByte() {
        return ConvertUtils.hexString2Bytes(this.emvATC);
    }

    public void setEmvATC(byte[] ATC) {
        this.emvATC = ConvertUtils.bytes2HexString(ATC, null);
    }

    public byte[] getEmvTVRByte() {
        return ConvertUtils.hexString2Bytes(this.emvTVR);
    }

    public void setEmvTVR(byte[] TVR) {
        this.emvTVR = ConvertUtils.bytes2HexString(TVR, null);
    }

    public byte[] getEmvTransactionDateByte() {
        return ConvertUtils.hexString2Bytes(this.emvTransDate);
    }

    public void setEmvTransactionDate(byte[] transactionDate) {
        this.emvTransDate = ConvertUtils.bytes2HexString(transactionDate, null);
    }

    public byte[] getTransAmountByte() {
        return ConvertUtils.hexString2Bytes(this.emvTransAmount);
    }

    public void setTransAmount(byte[] transAmount) {
        this.emvTransAmount = ConvertUtils.bytes2HexString(transAmount, null);
    }

    public byte[] getTransCurrencyCodeByte() {
        return ConvertUtils.hexString2Bytes(this.emvCurrencyCode);
    }

    public void setTransCurrencyCode(byte[] transCurrencyCode) {
        this.emvCurrencyCode = ConvertUtils.bytes2HexString(transCurrencyCode, null);
    }

    public byte[] getEmvCountryCodeByte() {
        return ConvertUtils.hexString2Bytes(this.emvCountryCode);
    }

    public void setEmvCountryCode(byte[] countryCode) {
        this.emvCountryCode = ConvertUtils.bytes2HexString(countryCode, null);
    }

    public byte[] getEmvAIPByte() {
        return ConvertUtils.hexString2Bytes(this.emvAIP);
    }

    public void setEmvAIP(byte[] AIP) {
        this.emvAIP = ConvertUtils.bytes2HexString(AIP, null);
    }

    public byte[] getEmvTermCapByte() {
        return ConvertUtils.hexString2Bytes(this.emvTermCap);
    }

    public void setEmvTermCap(byte[] termCap) {
        this.emvTermCap = ConvertUtils.bytes2HexString(termCap, null);
    }

    public byte[] getEmvCVMResultByte() {
        return ConvertUtils.hexString2Bytes(this.emvCVMResult);
    }

    public void setEmvCVMResult(byte[] CVMResult) {
        this.emvCVMResult = ConvertUtils.bytes2HexString(CVMResult, null);
    }

    public byte[] getEmvAmountOtherByte() {
        return ConvertUtils.hexString2Bytes(this.emvAmountOther);
    }

    public void setEmvAmountOther(byte[] amountOther) {
        this.emvAmountOther = ConvertUtils.bytes2HexString(amountOther, null);
    }

    public byte[] getEmvAIDByte() {
        return ConvertUtils.hexString2Bytes(this.emvAID);
    }

    public void setEmvAID(byte[] AID) {
        this.emvAID = ConvertUtils.bytes2HexString(AID, null);
    }

    public byte[] getEmvAppVerNumByte() {
        return ConvertUtils.hexString2Bytes(this.emvAppVer);
    }

    public void setEmvAppVerNum(byte[] appVerNum) {
        this.emvAppVer = ConvertUtils.bytes2HexString(appVerNum, null);
    }

    public byte[] getEmvTermAppVerNumByte() {
        return ConvertUtils.hexString2Bytes(this.emvTermAppVer);
    }

    public void setEmvTermAppVerNum(byte[] termAppVerNum) {
        this.emvTermAppVer = ConvertUtils.bytes2HexString(termAppVerNum, null);
    }

    public byte[] getEmvTransSeqCntByte() {
        return ConvertUtils.hexString2Bytes(this.emvTransSeqCnt);
    }

    public void setEmvTransSeqCnt(byte[] transSeqCnt) {
        this.emvTransSeqCnt = ConvertUtils.bytes2HexString(transSeqCnt, null);
    }

    public byte[] getEmvFFIByte() {
        return ConvertUtils.hexString2Bytes(this.emvFFI);
    }

    public void setEmvFFI(byte[] FFI) {
        this.emvFFI = ConvertUtils.bytes2HexString(FFI, null);
    }

    public byte[] getEmvIDNByte() {
        return ConvertUtils.hexString2Bytes(this.emvIDN);
    }

    public void setEmvIDN(byte[] IDN) {
        this.emvIDN = ConvertUtils.bytes2HexString(IDN, null);
    }

    public byte[] getEmvAOSAByte() {
        return ConvertUtils.hexString2Bytes(this.emvAOSA);
    }

    public void setEmvAOSA(byte[] AOSA) {
        this.emvAOSA = ConvertUtils.bytes2HexString(AOSA, null);
    }

    public byte[] getEmvTSIByte() {
        return ConvertUtils.hexString2Bytes(this.emvTSI);
    }

    public void setEmvTSI(byte[] TSI) {
        this.emvTSI = ConvertUtils.bytes2HexString(TSI, null);
    }

    public byte[] getEmvIssAuthDataByte() {
        return ConvertUtils.hexString2Bytes(this.emvIssAuthData);
    }

    public void setEmvIssAuthData(byte[] issAuthData) {
        this.emvIssAuthData = ConvertUtils.bytes2HexString(issAuthData, null);
    }

    public byte[] getEmvScriptResultByte() {
        return ConvertUtils.hexString2Bytes(this.emvScriptResult);
    }

    public void setEmvScriptResult(byte[] scriptResult) {
        this.emvScriptResult = ConvertUtils.bytes2HexString(scriptResult, null);
    }

    public TransType getTransTypeEnum() {
        return TransType.values()[getTransID()];
    }

    public void setTransType(TransType transType) {
        this.transID = transType.ordinal();
    }

    public CardType getCardTypeEnum() {
        return CardType.values()[getCardType()];
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType.ordinal();
    }

    public CtlsFlowType getCardCtlsTypeEnum() {
        return CtlsFlowType.values()[getCardCtlsFlowType()];
    }

    public void setCardCtlsFlowType(CtlsFlowType ctlsType) {
        this.cardCtlsFlowType = ctlsType.ordinal();
    }

    public ReversalReason getStatusReversalReasonEnum() {
        return ReversalReason.values()[getStatusReversalReason()];
    }

    public void setStatusReversalReason(ReversalReason reversalReason) {
        this.statusReversalReason = reversalReason.ordinal();
    }

    public DataConstant.OffUploadStatus getStatusOfflineUploadEnum() {
        return DataConstant.OffUploadStatus.values()[getStatusOffineUpload()];
    }

    public void setStatusOffineUpload(DataConstant.OffUploadStatus status) {
        this.statusOffineUpload = status.ordinal();
    }

    public DataConstant.BatchUploadStatus getStatusBatchUploadEnum() {
        return DataConstant.BatchUploadStatus.values()[getStatusBatchUpload()];
    }

    public void setStatusBatchUpload(DataConstant.BatchUploadStatus status) {
        this.statusBatchUpload = status.ordinal();
    }

    //Db field encrypt methods
    public String getCardNoEnc() {
        return cardNo;
    }

    public void setCardNoEnc(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardHolderNameEnc() {
        return cardHolderName;
    }

    public void setCardHolderNameEnc(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getCardExpDateEnc() {
        return cardExpDate;
    }

    public void setCardExpDateEnc(String cardExpDate) {
        this.cardExpDate = cardExpDate;
    }

    //End added methods

    /*****************************************************/
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getTransID() {
        return this.transID;
    }

    public void setTransID(int transID) {
        this.transID = transID;
    }

    public int getCardType() {
        return this.cardType;
    }

    public void setCardType(int cardType) {
        this.cardType = cardType;
    }

    public int getCardCtlsFlowType() {
        return this.cardCtlsFlowType;
    }

    public void setCardCtlsFlowType(int cardCtlsFlowType) {
        this.cardCtlsFlowType = cardCtlsFlowType;
    }

    public boolean getCardFallback() {
        return this.cardFallback;
    }

    public void setCardFallback(boolean cardFallback) {
        this.cardFallback = cardFallback;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String cardNo) {
        if (cardNo == null) {
            this.cardNo = null;
            return;
        }
        this.cardNo = cardNo;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getCardExpDate() {
        return this.cardExpDate;
    }

    public void setCardExpDate(String cardExpDate) {
        this.cardExpDate = cardExpDate;
    }

    public String getEmvAC() {
        return this.emvAC;
    }

    public void setEmvAC(String emvAC) {
        this.emvAC = emvAC;
    }

    public String getEmvCID() {
        return this.emvCID;
    }

    public void setEmvCID(String emvCID) {
        this.emvCID = emvCID;
    }

    public String getEmvIAD() {
        return this.emvIAD;
    }

    public void setEmvIAD(String emvIAD) {
        this.emvIAD = emvIAD;
    }

    public String getEmvUN() {
        return this.emvUN;
    }

    public void setEmvUN(String emvUN) {
        this.emvUN = emvUN;
    }

    public String getEmvATC() {
        return this.emvATC;
    }

    public void setEmvATC(String emvATC) {
        this.emvATC = emvATC;
    }

    public String getEmvTVR() {
        return this.emvTVR;
    }

    public void setEmvTVR(String emvTVR) {
        this.emvTVR = emvTVR;
    }

    public String getEmvTransDate() {
        return this.emvTransDate;
    }

    public void setEmvTransDate(String emvTransDate) {
        this.emvTransDate = emvTransDate;
    }

    public String getEmvTransType() {
        return this.emvTransType;
    }

    public void setEmvTransType(String emvTransType) {
        this.emvTransType = emvTransType;
    }

    public String getEmvTransAmount() {
        return this.emvTransAmount;
    }

    public void setEmvTransAmount(String emvTransAmount) {
        this.emvTransAmount = emvTransAmount;
    }

    public String getEmvCurrencyCode() {
        return this.emvCurrencyCode;
    }

    public void setEmvCurrencyCode(String emvCurrencyCode) {
        this.emvCurrencyCode = emvCurrencyCode;
    }

    public String getEmvCountryCode() {
        return this.emvCountryCode;
    }

    public void setEmvCountryCode(String emvCountryCode) {
        this.emvCountryCode = emvCountryCode;
    }

    public String getEmvAIP() {
        return this.emvAIP;
    }

    public void setEmvAIP(String emvAIP) {
        this.emvAIP = emvAIP;
    }

    public String getEmvTermCap() {
        return this.emvTermCap;
    }

    public void setEmvTermCap(String emvTermCap) {
        this.emvTermCap = emvTermCap;
    }

    public String getEmvCVMResult() {
        return this.emvCVMResult;
    }

    public void setEmvCVMResult(String emvCVMResult) {
        this.emvCVMResult = emvCVMResult;
    }

    public String getEmvAmountOther() {
        return this.emvAmountOther;
    }

    public void setEmvAmountOther(String emvAmountOther) {
        this.emvAmountOther = emvAmountOther;
    }

    public String getEmvAID() {
        return this.emvAID;
    }

    public void setEmvAID(String emvAID) {
        this.emvAID = emvAID;
    }

    public String getEmvAppVer() {
        return this.emvAppVer;
    }

    public void setEmvAppVer(String emvAppVer) {
        this.emvAppVer = emvAppVer;
    }

    public String getEmvTermAppVer() {
        return this.emvTermAppVer;
    }

    public void setEmvTermAppVer(String emvTermAppVer) {
        this.emvTermAppVer = emvTermAppVer;
    }

    public String getEmvTermType() {
        return this.emvTermType;
    }

    public void setEmvTermType(String emvTermType) {
        this.emvTermType = emvTermType;
    }

    public String getEmvIFDSN() {
        return this.emvIFDSN;
    }

    public void setEmvIFDSN(String emvIFDSN) {
        this.emvIFDSN = emvIFDSN;
    }

    public String getEmvCategoryCode() {
        return this.emvCategoryCode;
    }

    public void setEmvCategoryCode(String emvCategoryCode) {
        this.emvCategoryCode = emvCategoryCode;
    }

    public String getEmvTransSeqCnt() {
        return this.emvTransSeqCnt;
    }

    public void setEmvTransSeqCnt(String emvTransSeqCnt) {
        this.emvTransSeqCnt = emvTransSeqCnt;
    }

    public String getEmvFFI() {
        return this.emvFFI;
    }

    public void setEmvFFI(String emvFFI) {
        this.emvFFI = emvFFI;
    }

    public String getEmvIDN() {
        return this.emvIDN;
    }

    public void setEmvIDN(String emvIDN) {
        this.emvIDN = emvIDN;
    }

    public String getEmvAOSA() {
        return this.emvAOSA;
    }

    public void setEmvAOSA(String emvAOSA) {
        this.emvAOSA = emvAOSA;
    }

    public String getEmvTSI() {
        return this.emvTSI;
    }

    public void setEmvTSI(String emvTSI) {
        this.emvTSI = emvTSI;
    }

    public String getEmvPanSN() {
        return this.emvPanSN;
    }

    public void setEmvPanSN(String emvPanSN) {
        this.emvPanSN = emvPanSN;
    }

    public String getEmvAppLabel() {
        return this.emvAppLabel;
    }

    public void setEmvAppLabel(String emvAppLabel) {
        this.emvAppLabel = emvAppLabel;
    }

    public String getEmvAppPreferName() {
        return this.emvAppPreferName;
    }

    public void setEmvAppPreferName(String emvAppPreferName) {
        this.emvAppPreferName = emvAppPreferName;
    }

    public String getEmvIssAuthData() {
        return this.emvIssAuthData;
    }

    public void setEmvIssAuthData(String emvIssAuthData) {
        this.emvIssAuthData = emvIssAuthData;
    }

    public String getEmvScriptResult() {
        return this.emvScriptResult;
    }

    public void setEmvScriptResult(String emvScriptResult) {
        this.emvScriptResult = emvScriptResult;
    }

    public String getMsgCashierNO() {
        return this.msgCashierNO;
    }

    public void setMsgCashierNO(String msgCashierNO) {
        this.msgCashierNO = msgCashierNO;
    }

    public String getMsgBitmap() {
        return this.msgBitmap;
    }

    public void setMsgBitmap(String msgBitmap) {
        this.msgBitmap = msgBitmap;
    }

    public String getMsgProcCode() {
        return this.msgProcCode;
    }

    public void setMsgProcCode(String msgProcCode) {
        this.msgProcCode = msgProcCode;
    }

    public String getMsgAmount() {
        return this.msgAmount;
    }

    public void setMsgAmount(String msgAmount) {
        this.msgAmount = msgAmount;
    }

    public String getMsgDateTime() {
        return this.msgDateTime;
    }

    public void setMsgDateTime(String msgDateTime) {
        this.msgDateTime = msgDateTime;
    }

    public String getMsgTraceNO() {
        return this.msgTraceNO;
    }

    public void setMsgTraceNO(String msgTraceNO) {
        this.msgTraceNO = msgTraceNO;
    }

    public String getMsgEntryMode() {
        return this.msgEntryMode;
    }

    public void setMsgEntryMode(String msgEntryMode) {
        this.msgEntryMode = msgEntryMode;
    }

    public String getMsgConditionCode() {
        return this.msgConditionCode;
    }

    public void setMsgConditionCode(String msgConditionCode) {
        this.msgConditionCode = msgConditionCode;
    }

    public String getMsgPinCapCode() {
        return this.msgPinCapCode;
    }

    public void setMsgPinCapCode(String msgPinCapCode) {
        this.msgPinCapCode = msgPinCapCode;
    }

    public String getMsgTermID() {
        return this.msgTermID;
    }

    public void setMsgTermID(String msgTermID) {
        this.msgTermID = msgTermID;
    }

    public String getMsgMerchID() {
        return this.msgMerchID;
    }

    public void setMsgMerchID(String msgMerchID) {
        this.msgMerchID = msgMerchID;
    }

    public String getMsgTipAmount() {
        return this.msgTipAmount;
    }

    public void setMsgTipAmount(String msgTipAmount) {
        this.msgTipAmount = msgTipAmount;
    }

    public String getMsgCurrencyCode() {
        return this.msgCurrencyCode;
    }

    public void setMsgCurrencyCode(String msgCurrencyCode) {
        this.msgCurrencyCode = msgCurrencyCode;
    }

    public String getMsgFuncCode() {
        return this.msgFuncCode;
    }

    public void setMsgFuncCode(String msgFuncCode) {
        this.msgFuncCode = msgFuncCode;
    }

    public String getMsgBatchNO() {
        return this.msgBatchNO;
    }

    public void setMsgBatchNO(String msgBatchNO) {
        this.msgBatchNO = msgBatchNO;
    }

    public String getMsgOrigBatchNO() {
        return this.msgOrigBatchNO;
    }

    public void setMsgOrigBatchNO(String msgOrigBatchNO) {
        this.msgOrigBatchNO = msgOrigBatchNO;
    }

    public String getMsgOrigTraceNO() {
        return this.msgOrigTraceNO;
    }

    public void setMsgOrigTraceNO(String msgOrigTraceNO) {
        this.msgOrigTraceNO = msgOrigTraceNO;
    }

    public String getMsgOrigDate() {
        return this.msgOrigDate;
    }

    public void setMsgOrigDate(String msgOrigDate) {
        this.msgOrigDate = msgOrigDate;
    }

    public String getMsgCashbackAmount() {
        return this.msgCashbackAmount;
    }

    public void setMsgCashbackAmount(String msgCashbackAmount) {
        this.msgCashbackAmount = msgCashbackAmount;
    }

    public String getMsgTransTime() {
        return this.msgTransTime;
    }

    public void setMsgTransTime(String msgTransTime) {
        this.msgTransTime = msgTransTime;
    }

    public String getMsgTransDate() {
        return this.msgTransDate;
    }

    public void setMsgTransDate(String msgTransDate) {
        this.msgTransDate = msgTransDate;
    }

    public String getMsgSettlementDate() {
        return this.msgSettlementDate;
    }

    public void setMsgSettlementDate(String msgSettlementDate) {
        this.msgSettlementDate = msgSettlementDate;
    }

    public String getMsgAcqID() {
        return this.msgAcqID;
    }

    public void setMsgAcqID(String msgAcqID) {
        this.msgAcqID = msgAcqID;
    }

    public String getMsgRefNO() {
        return this.msgRefNO;
    }

    public void setMsgRefNO(String msgRefNO) {
        this.msgRefNO = msgRefNO;
    }

    public String getMsgAuthCode() {
        return this.msgAuthCode;
    }

    public void setMsgAuthCode(String msgAuthCode) {
        this.msgAuthCode = msgAuthCode;
    }

    public String getMsgRespCode() {
        return this.msgRespCode;
    }

    public void setMsgRespCode(String msgRespCode) {
        this.msgRespCode = msgRespCode;
    }

    public String getMsgIssuerCode() {
        return this.msgIssuerCode;
    }

    public void setMsgIssuerCode(String msgIssuerCode) {
        this.msgIssuerCode = msgIssuerCode;
    }

    public String getMsgAcquirerCode() {
        return this.msgAcquirerCode;
    }

    public void setMsgAcquirerCode(String msgAcquirerCode) {
        this.msgAcquirerCode = msgAcquirerCode;
    }

    public String getMsgBalance() {
        return this.msgBalance;
    }

    public void setMsgBalance(String msgBalance) {
        this.msgBalance = msgBalance;
    }

    public String getMsgInterOrgCode() {
        return this.msgInterOrgCode;
    }

    public void setMsgInterOrgCode(String msgInterOrgCode) {
        this.msgInterOrgCode = msgInterOrgCode;
    }

    public String getMsgIssuerInfo() {
        return this.msgIssuerInfo;
    }

    public void setMsgIssuerInfo(String msgIssuerInfo) {
        this.msgIssuerInfo = msgIssuerInfo;
    }

    public String getMsgCUPInfo() {
        return this.msgCUPInfo;
    }

    public void setMsgCUPInfo(String msgCUPInfo) {
        this.msgCUPInfo = msgCUPInfo;
    }

    public String getMsgAcqInfo() {
        return this.msgAcqInfo;
    }

    public void setMsgAcqInfo(String msgAcqInfo) {
        this.msgAcqInfo = msgAcqInfo;
    }

    public String getMsgTermReserved() {
        return this.msgTermReserved;
    }

    public void setMsgTermReserved(String msgTermReserved) {
        this.msgTermReserved = msgTermReserved;
    }

    public boolean getStatusIccFailTrans() {
        return this.statusIccFailTrans;
    }

    public void setStatusIccFailTrans(boolean statusIccFailTrans) {
        this.statusIccFailTrans = statusIccFailTrans;
    }

    public boolean getStatusOffline() {
        return this.statusOffline;
    }

    public void setStatusOffline(boolean statusOffline) {
        this.statusOffline = statusOffline;
    }

    public boolean getStatusVoided() {
        return this.statusVoided;
    }

    public void setStatusVoided(boolean statusVoided) {
        this.statusVoided = statusVoided;
    }

    public boolean getStatusAdjusted() {
        return this.statusAdjusted;
    }

    public void setStatusAdjusted(boolean statusAdjusted) {
        this.statusAdjusted = statusAdjusted;
    }

    public boolean getStatusNeedPrint() {
        return this.statusNeedPrint;
    }

    public void setStatusNeedPrint(boolean statusNeedPrint) {
        this.statusNeedPrint = statusNeedPrint;
    }

    public boolean getStatusNeedReversal() {
        return this.statusNeedReversal;
    }

    public void setStatusNeedReversal(boolean statusNeedReversal) {
        this.statusNeedReversal = statusNeedReversal;
    }

    public boolean getStatusNeedScript() {
        return this.statusNeedScript;
    }

    public void setStatusNeedScript(boolean statusNeedScript) {
        this.statusNeedScript = statusNeedScript;
    }

    public int getStatusReversalReason() {
        return this.statusReversalReason;
    }

    public void setStatusReversalReason(int statusReversalReason) {
        this.statusReversalReason = statusReversalReason;
    }

    public int getStatusAdjustedTimes() {
        return this.statusAdjustedTimes;
    }

    public void setStatusAdjustedTimes(int statusAdjustedTimes) {
        this.statusAdjustedTimes = statusAdjustedTimes;
    }

    public int getStatusOffineUpload() {
        return this.statusOffineUpload;
    }

    public void setStatusOffineUpload(int statusOffineUpload) {
        this.statusOffineUpload = statusOffineUpload;
    }

    public int getStatusBatchUpload() {
        return this.statusBatchUpload;
    }

    public void setStatusBatchUpload(int statusBatchUpload) {
        this.statusBatchUpload = statusBatchUpload;
    }

    public String getRfu1() {
        return this.rfu1;
    }

    public void setRfu1(String rfu1) {
        this.rfu1 = rfu1;
    }

    public String getRfu2() {
        return this.rfu2;
    }

    public void setRfu2(String rfu2) {
        this.rfu2 = rfu2;
    }

    public String getRfu3() {
        return this.rfu3;
    }

    public void setRfu3(String rfu3) {
        this.rfu3 = rfu3;
    }

    public String getEmvCardId() {
        return this.emvCardId;
    }

    public void setEmvCardId(String emvCardId) {
        this.emvCardId = emvCardId;
    }

    public boolean getStatusArpcErr() {
        return this.statusArpcErr;
    }

    public void setStatusArpcErr(boolean statusArpcErr) {
        this.statusArpcErr = statusArpcErr;
    }


}
