package cn.nexgo.inbas.components.data.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Generated;

import cn.nexgo.inbas.common.Constans.CardAcq;
import cn.nexgo.inbas.components.data.DataConstant;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : CardBinEntity.java
 * Usage         :
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/4/11
 * Modification  : Created file

 **************************************************************************************************/
@Entity(
        nameInDb = "CARDBIN_TABLE",   // Table Name
        createInDb = true,             // if create a tablE
        generateConstructors = true,   // if generate constructors.
        generateGettersSetters = true  // If generate getters and setters' methods
)
public class CardBinEntity {
    @Id(autoincrement = true)
    private Long id;                            // Unique id for each record

    @Property(nameInDb = "STARTPREFIX")
    private String startPrefix;                    // start prefix of card bin range
    @Property(nameInDb = "ENDPREFIX")
    private String endPrefix;                      // end prefix of card bin range
    @Property(nameInDb = "CARD_ACQUIRER")
    private int cardAcq;                           // card acquirer type

    @Property(nameInDb = "RFU_1")
    private String rfu1;                           // rfu

    @Generated(hash = 1308194454)
    public CardBinEntity(Long id, String startPrefix, String endPrefix, int cardAcq, String rfu1) {
        this.id = id;
        this.startPrefix = startPrefix;
        this.endPrefix = endPrefix;
        this.cardAcq = cardAcq;
        this.rfu1 = rfu1;
    }

    @Generated(hash = 1638719367)
    public CardBinEntity() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStartPrefix() {
        return this.startPrefix;
    }

    public void setStartPrefix(String startPrefix) {
        this.startPrefix = startPrefix;
    }

    public String getEndPrefix() {
        return this.endPrefix;
    }

    public void setEndPrefix(String endPrefix) {
        this.endPrefix = endPrefix;
    }

    public int getCardAcq() {
        return this.cardAcq;
    }

    public void setCardAcq(int cardAcq) {
        this.cardAcq = cardAcq;
    }

    public String getRfu1() {
        return this.rfu1;
    }

    public void setRfu1(String rfu1) {
        this.rfu1 = rfu1;
    }

    //added more getters and setters
    public CardAcq getCardAcqEnum() {
        for (CardAcq cardAcq : CardAcq.values()){
            if(cardAcq.ordinal() == getCardAcq()){
                return cardAcq;
            }
        }
        return null;
    }
    public void setCardAcq(CardAcq cardAcq) {
        this.cardAcq = cardAcq.ordinal();
    }
    //ended add getters and setters


}
