package cn.nexgo.inbas.components.data;


import org.greenrobot.greendao.query.QueryBuilder;

import cn.nexgo.inbas.components.data.repository.CardBinRepository;
import cn.nexgo.inbas.components.data.repository.OperatorRepository;
import cn.nexgo.inbas.components.data.repository.SettleInfoRepository;
import cn.nexgo.inbas.components.data.repository.SetupRepository;
import cn.nexgo.inbas.components.data.repository.TransRecordRepository;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : DataOpenHelper.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/15 
 * Modification  : Created file

 **************************************************************************************************/
public class DataOpenHelper{

    public static boolean LOG_ENABLE = false;
    /**
     * enable log
     * @param log if enable log
     */
    public static void enableLog(boolean log){
        LOG_ENABLE = log;
        //QueryBuilder.LOG_SQL = true;
        //QueryBuilder.LOG_VALUES = true;
    }

    private static volatile DataOpenHelper INSTANCE;
    private DataOpenHelper(){

    }

    /**
     * Singleton
     * @return DataOpenHelper instance
     */
    public static DataOpenHelper getInstance(){
        if (INSTANCE == null){
            synchronized (DataOpenHelper.class){
                if (INSTANCE == null){
                    INSTANCE = new DataOpenHelper();
                }
            }
        }
        return INSTANCE;
    }

    /**
     * get TransRecordRepository(Singleton)
     * @return TransRecordRepository(Singleton)
     */
    public TransRecordRepository getTransRecordRepository(){
        return TransRecordRepository.getInstance();
    }

    /**
     * get SetupRepository(Singleton)
     * @return SetupRepository(Singleton)
     */

    public SetupRepository getSetupRepository(){
        return SetupRepository.getInstance();
    }

    /**
     * get OperatorRepository(Singleton)
     * @return OperatorRepository(Singleton)
     */
    public OperatorRepository getOperatorRepository(){
        return OperatorRepository.getInstance();
    }

    /**
     * get SettleInfoRepository(Singleton)
     * @return SettleInfoRepository(Singleton)
     */
    public SettleInfoRepository getSettleInfoRepository(){
        return SettleInfoRepository.getInstance();
    }

    public CardBinRepository getCardBinRepository(){
        return CardBinRepository.getInstance();
    }
}
