package cn.nexgo.inbas.components.data;

import android.os.Environment;

import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : DataConstant.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/14 
 * Modification  : Created file

 **************************************************************************************************/
public class DataConstant {

    public static final int MAX_CASHIER_NUM = 10;     //Maximum cashier numbers

//    public enum TransID{
//        UNKNOWN,
//
//        LOGON,                  // login transaction
////        LOGOUT,                 // logout transaction
//        BALANCE,                // balance inquire transaction
//
//        SALE,                   // sale transaction
//        VOID,                   // void transaction
//        REFUND,                 // refund transaction
//        ADJUST,                 // adjust transaction for offline settlement
//        TIP,                    // tip transaction for sale
//        //OFFSALE,                // offline sale
//        SETTLE,                 // settle
//
//        REVERSAL,               // reversal
//        SCRIPT,                 // script
//
//    }


    public enum CtlsFlowType {
        QUICK,                  // Contactless QPBOC/EMV
        MSD,                    // Contactless MSD
    }


    public enum ReversalReason{
        OTHER,                  //other reason
        RECV_TIMEOUT,           //Receiving timeout
        MAC_ERR,                //MAC error
        AUTH_FAIL               //Auth failed
    }

    //offline upload
    public enum OffUploadStatus {
        OFFLINE_NONE,            //not uploaded
        OFFLINE_SUCCESS,         //upload success
        OFFLINE_FAIL,            //fail to upload
        OFFLINE_DECLINE,         //uploaded but rejected


    }

    //batch upload status for each transaction(TransRecordEntity)
    public enum BatchUploadStatus {
        BATCH_UNFINISH,          //batch upload is not finished
        BATCH_DONE,              //batch upload success

    }

    // Batch upload status for whole transactions of this batch(BatchInfoEntity)
    public enum BatchStatus{
        UPLOAD_NONE,              // Have not started Batch upload yet
        UPLOAD_UNFINISH,          // Batch Uploading is not finished
        UPLOAD_DONE,              // Batch uploading finished
    }

    // Settlement status for whole transactions of this batch
    public enum SettleStatus{
        NONE,                    // Have not started settlement yet
        BALANCED,                // Get Settlement response and balanced
        UNBALANCED,              // Get Settlement response and unbalanced
        NOT_PRINT,               // not print or printing failed
        PRINTED,                 // print success
        BATCH_CLEARED,           // clear the batch record
    }

    public enum MsgLenType{
        ASCII,
        BCD,
        HEX
    }

    public enum CommuMode{
        SOCKET,
        HTTP,
        HTTPS,
    }

    public final static String APPDIR = Environment.getExternalStorageDirectory().getPath()+"/"+ BaseUtils.getApp().getPackageName() + "/";

}
