package cn.nexgo.inbas.components.commu.socket.factory;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

import javax.net.SocketFactory;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/10
 * Modify          : create file
 **************************************************************************************************/
public class SSLSocket implements ISocket {
    private SocketFactory factory;
    public void setSslFactory(SocketFactory factory){
        this.factory = factory;
    }

    private javax.net.ssl.SSLSocket mSslSocket;
    @Override
    public void close() {
        if(!isConnect()){
            return;
        }
        try {
            mSslSocket.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String ip;
    private String port;
    private InputStream inStream = null;
    private DataOutputStream output = null;
    @Override
    public boolean socket(String ip, String port, int timeout) {
        if(factory == null){
            return false;
        }
        if(ip.equals(this.ip) && (port.equals(this.port)) && isConnect()){  // if has connected & ip port is same
            return true;
        }else{
            close();
        }

        this.ip = ip;
        this.port = port;

        SocketAddress sa = new InetSocketAddress(this.ip, Integer.parseInt(this.port));
        try {
            mSslSocket = (javax.net.ssl.SSLSocket) factory.createSocket();
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }

        try {   //  set connect params
            mSslSocket.setSoTimeout(timeout);
            mSslSocket.setTcpNoDelay(true);
        } catch (SocketException e) {
            e.printStackTrace();
            return false;
        }

        try {  // connect
            mSslSocket.connect(sa, timeout);
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }

        try {  // get stream
            output = new DataOutputStream(mSslSocket.getOutputStream());
            inStream = mSslSocket.getInputStream();
        } catch (IOException e) {
            e.printStackTrace();
            close();
        }

        return true;
    }

    @Override
    public boolean sendDatas(byte[] sendDatas, int timeout) {
        if(!isConnect()){
            return false;
        }

        try {
            output.write(sendDatas);
            output.flush();
        } catch (IOException e) {
            e.printStackTrace();
            close();
            return false;
        }

        return true;
    }

    @Override
    public int readDatas(byte[] b, int off, int len, int timeout) {
        if(!isConnect()){
            return -1;
        }

        int realReadLen = 0;
        try {
            realReadLen = inStream.read(b, off, len);
        } catch (IOException e) {
            e.printStackTrace();
            close();
            return -1;
        }

        return realReadLen;
    }

    @Override
    public boolean isConnect() {
        if((mSslSocket == null) || (!mSslSocket.isConnected())){
            return false;
        }
        return true;
    }
}
