package cn.nexgo.inbas.common.widget.sectionedrecyclerview;

import android.support.v7.widget.GridLayoutManager;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :  A SpanSizeLookup to draw section headers or footer spanning the whole width of the RecyclerView when using a GridLayoutManager
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/26
 * Modify          : create file
 **************************************************************************************************/

public class SectionedSpanSizeLookup extends GridLayoutManager.SpanSizeLookup {

    protected SectionedRecyclerViewAdapter<?, ?, ?> adapter = null;
    protected GridLayoutManager layoutManager = null;

    public SectionedSpanSizeLookup(SectionedRecyclerViewAdapter<?, ?, ?> adapter, GridLayoutManager layoutManager) {
        this.adapter = adapter;
        this.layoutManager = layoutManager;
    }

    @Override
    public int getSpanSize(int position) {

        if (adapter.isSectionHeaderPosition(position) || adapter.isSectionFooterPosition(position)) {
            return layoutManager.getSpanCount();
        } else {
            return 1;
        }

    }
}
