package cn.nexgo.inbas.common.widget.keyboard;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;

import com.nexgo.oaf.apiv3.device.pinpad.PinpadLayoutEntity;

import java.util.Arrays;

import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2018/1/4
 * Modify          : create file
 **************************************************************************************************/

public class PinKeyBoard extends FrameLayout {
    private Context context;
    private int[] pinLen;

    public PinKeyBoard(@NonNull Context context) {
        super(context);
        init(context);
    }

    public PinKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public PinKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    public void setPinLen(int[] pinLen) {
        this.pinLen = pinLen;
        int i = Arrays.binarySearch(pinLen, 0);
        keyboardConfirm.setEnabled(i >= 0);
    }

    // 初始化
    protected Button keyboard1;
    protected Button keyboard2;
    protected Button keyboard3;
    protected Button keyboard4;
    protected Button keyboard5;
    protected Button keyboard6;
    protected ImageButton keyboardCancel;
    protected Button keyboard7;
    protected Button keyboard8;
    protected Button keyboard9;
    protected ImageButton keyboardConfirm;
    protected Button keyboard0;
    protected Button keyboardClear;

    private void init(Context context) {
        this.context = context;
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        //noinspection ConstantConditions
        inflater.inflate(R.layout.widget_input_pin_numkeyboard, this);

        keyboard1 = findViewById(R.id.keyboard_1);
        keyboard2 = findViewById(R.id.keyboard_2);
        keyboard3 = findViewById(R.id.keyboard_3);
        keyboard4 = findViewById(R.id.keyboard_4);
        keyboard5 = findViewById(R.id.keyboard_5);
        keyboard6 = findViewById(R.id.keyboard_6);
        keyboard7 = findViewById(R.id.keyboard_7);
        keyboard8 = findViewById(R.id.keyboard_8);
        keyboard9 = findViewById(R.id.keyboard_9);
        keyboard0 = findViewById(R.id.keyboard_0);
        keyboardClear = findViewById(R.id.keyboard_clear);
        keyboardCancel = findViewById(R.id.keyboard_cancel);
        keyboardConfirm = findViewById(R.id.keyboard_confirm);

        keyboard1.setOnClickListener(onClickListener);
        keyboard2.setOnClickListener(onClickListener);
        keyboard3.setOnClickListener(onClickListener);
        keyboard4.setOnClickListener(onClickListener);
        keyboard5.setOnClickListener(onClickListener);
        keyboard6.setOnClickListener(onClickListener);
        keyboard7.setOnClickListener(onClickListener);
        keyboard8.setOnClickListener(onClickListener);
        keyboard9.setOnClickListener(onClickListener);
        keyboard0.setOnClickListener(onClickListener);
        keyboardClear.setOnClickListener(onClickListener);
        keyboardCancel.setOnClickListener(onClickListener);
        keyboardConfirm.setOnClickListener(onClickListener);
    }

    private OnClickListener onClickListener = new OnClickListener() {
        @Override
        public void onClick(View view) {
            if (callback == null) {
                return;
            }
            switch (view.getId()) {
                case R.id.keyboard_0:
                    callback.onKey(KEY_TYPE.KEY_0);
                    break;
                case R.id.keyboard_1:
                    callback.onKey(KEY_TYPE.KEY_1);
                    break;
                case R.id.keyboard_2:
                    callback.onKey(KEY_TYPE.KEY_2);
                    break;
                case R.id.keyboard_3:
                    callback.onKey(KEY_TYPE.KEY_3);
                    break;
                case R.id.keyboard_4:
                    callback.onKey(KEY_TYPE.KEY_4);
                    break;
                case R.id.keyboard_5:
                    callback.onKey(KEY_TYPE.KEY_5);
                    break;
                case R.id.keyboard_6:
                    callback.onKey(KEY_TYPE.KEY_6);
                    break;
                case R.id.keyboard_7:
                    callback.onKey(KEY_TYPE.KEY_7);
                    break;
                case R.id.keyboard_8:
                    callback.onKey(KEY_TYPE.KEY_8);
                    break;
                case R.id.keyboard_9:
                    callback.onKey(KEY_TYPE.KEY_9);
                    break;
                case R.id.keyboard_clear:
                    callback.onKey(KEY_TYPE.KEY_CLEAR);
                    break;
                case R.id.keyboard_cancel:
                    callback.onKey(KEY_TYPE.KEY_CANCEL);
                    break;
                case R.id.keyboard_confirm:
                    callback.onKey(KEY_TYPE.KEY_CONFIRM);
                    break;
            }
        }
    };


    // 设置回调
    private Callback callback;

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    // 按键回调
    public interface Callback {
        void onKey(KEY_TYPE keyType);
    }

    // 按键值枚举
    public enum KEY_TYPE {
        KEY_0("0"),
        KEY_1("1"),
        KEY_2("2"),
        KEY_3("3"),
        KEY_4("4"),
        KEY_5("5"),
        KEY_6("6"),
        KEY_7("7"),
        KEY_8("8"),
        KEY_9("9"),
        KEY_CLEAR("c"),
        KEY_CANCEL("b"),
        KEY_CONFIRM("o");

        private String keyValue;

        KEY_TYPE(String keyValue) {
            this.keyValue = keyValue;
        }

        public String getKeyValue() {
            return keyValue;
        }

    }

    public PinpadLayoutEntity getPinpadLayoutEntity() {
        PinpadLayoutEntity pinpadLayout = new PinpadLayoutEntity();
        int[] location = new int[2];
        Rect r;

        keyboard1.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard1.getWidth() + r.left;
        r.bottom = keyboard1.getHeight() + r.top;
        pinpadLayout.setKey1(r);

        keyboard2.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard2.getWidth() + r.left;
        r.bottom = keyboard2.getHeight() + r.top;
        pinpadLayout.setKey2(r);

        keyboard3.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard3.getWidth() + r.left;
        r.bottom = keyboard3.getHeight() + r.top;
        pinpadLayout.setKey3(r);

        keyboard4.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard4.getWidth() + r.left;
        r.bottom = keyboard4.getHeight() + r.top;
        pinpadLayout.setKey4(r);

        keyboard5.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard5.getWidth() + r.left;
        r.bottom = keyboard5.getHeight() + r.top;
        pinpadLayout.setKey5(r);

        keyboard6.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard6.getWidth() + r.left;
        r.bottom = keyboard6.getHeight() + r.top;
        pinpadLayout.setKey6(r);

        keyboard7.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard7.getWidth() + r.left;
        r.bottom = keyboard7.getHeight() + r.top;
        pinpadLayout.setKey7(r);

        keyboard8.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard8.getWidth() + r.left;
        r.bottom = keyboard8.getHeight() + r.top;
        pinpadLayout.setKey8(r);

        keyboard9.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard9.getWidth() + r.left;
        r.bottom = keyboard9.getHeight() + r.top;
        pinpadLayout.setKey9(r);

        keyboard0.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboard0.getWidth() + r.left;
        r.bottom = keyboard0.getHeight() + r.top;
        pinpadLayout.setKey10(r);

        keyboardCancel.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboardCancel.getWidth() + r.left;
        r.bottom = keyboardCancel.getHeight() + r.top;
        pinpadLayout.setKeyCancel(r);

        keyboardClear.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboardClear.getWidth() + r.left;
        r.bottom = keyboardClear.getHeight() + r.top;
        pinpadLayout.setKeyClear(r);

        keyboardConfirm.getLocationOnScreen(location);
        r = new Rect();
        r.left = location[0];
        r.top = location[1];
        r.right = keyboardConfirm.getWidth() + r.left;
        r.bottom = keyboardConfirm.getHeight() + r.top;
        pinpadLayout.setKeyConfirm(r);

        return pinpadLayout;
    }

    public void setKeyNum(byte[] bytes) {
        keyboard1.setText(String.valueOf(bytes[1]));
        keyboard2.setText(String.valueOf(bytes[2]));
        keyboard3.setText(String.valueOf(bytes[3]));
        keyboard4.setText(String.valueOf(bytes[4]));
        keyboard5.setText(String.valueOf(bytes[5]));
        keyboard6.setText(String.valueOf(bytes[6]));
        keyboard7.setText(String.valueOf(bytes[7]));
        keyboard8.setText(String.valueOf(bytes[8]));
        keyboard9.setText(String.valueOf(bytes[9]));
        keyboard0.setText(String.valueOf(bytes[0]));
    }

    public void refreshUI(int stringLen) {
        keyboardClear.setEnabled(stringLen != 0);

        if (pinLen == null)
            return;

        keyboardConfirm.setEnabled(false);
        for (int len : pinLen) {
            if (len == stringLen) {
                keyboardConfirm.setEnabled(true);
                return;
            }
        }
    }
}