package cn.nexgo.inbas.common.widget.keyboard;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;

import cn.nexgo.inbas.R;
import cn.nexgo.utils.MixUtils;


/**
 * Created by Kol(Fang Qiang) on 2017/8/2.
 * usage:
 */

public class NumKeyBoard extends FrameLayout {
    private Context context;

    public NumKeyBoard(@NonNull Context context) {
        super(context);
        init(context);
    }

    public NumKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public NumKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    // 初始化
    protected Button keyboard1;
    protected Button keyboard2;
    protected Button keyboard3;
    protected ImageButton keyboardCancel;
    protected Button keyboard4;
    protected Button keyboard5;
    protected Button keyboard6;
    protected ImageButton keyboardBackspace;
    protected Button keyboard7;
    protected Button keyboard8;
    protected Button keyboard9;
    protected ImageButton keyboardConfirm;
    protected Button keyboard0;
    protected Button keyboard00;
    protected Button keyboardClear;

    private void init(Context context){
        this.context = context;
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        //noinspection ConstantConditions
        inflater.inflate(R.layout.widget_input_numkeyboard, this);

        keyboard1 = findViewById(R.id.keyboard_1);
        keyboard2 = findViewById(R.id.keyboard_2);
        keyboard3 = findViewById(R.id.keyboard_3);
        keyboard4 = findViewById(R.id.keyboard_4);
        keyboard5 = findViewById(R.id.keyboard_5);
        keyboard6 = findViewById(R.id.keyboard_6);
        keyboard7 = findViewById(R.id.keyboard_7);
        keyboard8 = findViewById(R.id.keyboard_8);
        keyboard9 = findViewById(R.id.keyboard_9);
        keyboard0 = findViewById(R.id.keyboard_0);
        keyboard00 = findViewById(R.id.keyboard_00);
        keyboardClear = findViewById(R.id.keyboard_clear);
        keyboardCancel = findViewById(R.id.keyboard_cancel);
        keyboardBackspace = findViewById(R.id.keyboard_backspace);
        keyboardConfirm = findViewById(R.id.keyboard_confirm);

        keyboard1.setOnClickListener(onClickListener);
        keyboard2.setOnClickListener(onClickListener);
        keyboard3.setOnClickListener(onClickListener);
        keyboard4.setOnClickListener(onClickListener);
        keyboard5.setOnClickListener(onClickListener);
        keyboard6.setOnClickListener(onClickListener);
        keyboard7.setOnClickListener(onClickListener);
        keyboard8.setOnClickListener(onClickListener);
        keyboard9.setOnClickListener(onClickListener);
        keyboard0.setOnClickListener(onClickListener);
        keyboard00.setOnClickListener(onClickListener);
        keyboardClear.setOnClickListener(onClickListener);
        keyboardCancel.setOnClickListener(onClickListener);
        keyboardBackspace.setOnClickListener(onClickListener);
        keyboardConfirm.setOnClickListener(onClickListener);
    }

    private OnClickListener onClickListener = new OnClickListener() {
        @Override
        public void onClick(View view) {
            if(callback == null){
                return;
            }
            switch (view.getId()){
                case R.id.keyboard_0:
                    callback.onKey(KEY_TYPE.KEY_0);
                    break;
                case R.id.keyboard_1:
                    callback.onKey(KEY_TYPE.KEY_1);
                    break;
                case R.id.keyboard_2:
                    callback.onKey(KEY_TYPE.KEY_2);
                    break;
                case R.id.keyboard_3:
                    callback.onKey(KEY_TYPE.KEY_3);
                    break;
                case R.id.keyboard_4:
                    callback.onKey(KEY_TYPE.KEY_4);
                    break;
                case R.id.keyboard_5:
                    callback.onKey(KEY_TYPE.KEY_5);
                    break;
                case R.id.keyboard_6:
                    callback.onKey(KEY_TYPE.KEY_6);
                    break;
                case R.id.keyboard_7:
                    callback.onKey(KEY_TYPE.KEY_7);
                    break;
                case R.id.keyboard_8:
                    callback.onKey(KEY_TYPE.KEY_8);
                    break;
                case R.id.keyboard_9:
                    callback.onKey(KEY_TYPE.KEY_9);
                    break;
                case R.id.keyboard_00:
                    callback.onKey(KEY_TYPE.KEY_00);
                    break;
                case R.id.keyboard_clear:
                    callback.onKey(KEY_TYPE.KEY_CLEAR);
                    break;
                case R.id.keyboard_cancel:
                    callback.onKey(KEY_TYPE.KEY_CANCEL);
                    break;
                case R.id.keyboard_backspace:
                    callback.onKey(KEY_TYPE.KEY_BACKSPACE);
                    break;
                case R.id.keyboard_confirm:
                    if(MixUtils.preventDoubleEvent()){
                        return;
                    }
                    callback.onKey(KEY_TYPE.KEY_CONFIRM);
                    break;
            }
        }
    };

    // 设置回调
    private Callback callback;
    public void setCallback(Callback callback){
        this.callback = callback;
    }

    // 按键回调
    public interface Callback{
        void onKey(KEY_TYPE keyType);
    }

    // 按键值枚举
    public enum KEY_TYPE {
        KEY_0("0"),
        KEY_1("1"),
        KEY_2("2"),
        KEY_3("3"),
        KEY_4("4"),
        KEY_5("5"),
        KEY_6("6"),
        KEY_7("7"),
        KEY_8("8"),
        KEY_9("9"),
        KEY_00("00"),
        KEY_CANCEL("q"),
        KEY_CLEAR("c"),
        KEY_BACKSPACE("b"),
        KEY_CONFIRM("o");

        private String keyValue;

        KEY_TYPE(String keyValue) {
            this.keyValue = keyValue;
        }

        public String getKeyValue() {
            return keyValue;
        }
    }

}
