package cn.nexgo.inbas.common.widget.keyboard;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

/**
 * Created by Kol(Fang Qiang) on 2017/8/2.
 * usage:
 */

public class AmountNumKeyBoard extends NumKeyBoard {
    private Context context;

    public AmountNumKeyBoard(@NonNull Context context) {
        super(context);
        init(context);
    }

    public AmountNumKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public AmountNumKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        this.context = context;
        super.setCallback(_callback);
    }

    // 设置初始值
    public void setValue(long value) {
        currentValue = value;
        keyboardConfirm.setEnabled(currentValue >= minValue);
        if (callback != null) {
            callback.onEnable(currentValue >= minValue);
        }
    }

    // 设置最大值
    private long maxValue = Long.MAX_VALUE;
    public long minValue = 0L;
    private long currentValue = 0L;

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    // 获取结果
    public long getRet() {
        return currentValue;
    }

    private Callback _callback = new Callback() {
        @Override
        public void onKey(KEY_TYPE keyType) {
            currentValue = calAmountNum(currentValue, keyType);
            keyboardConfirm.setEnabled(currentValue >= minValue);
            callback.onEnable(currentValue >= minValue);
            if (callback != null) {
                callback.onKey(keyType);
            }
        }
    };

    public long calAmountNum(long currentValue, KEY_TYPE keyType) {
        long newAmount;

        switch (keyType) {
            case KEY_0:
            case KEY_1:
            case KEY_2:
            case KEY_3:
            case KEY_4:
            case KEY_5:
            case KEY_6:
            case KEY_7:
            case KEY_8:
            case KEY_9:
                // press 0-9 number
                newAmount = currentValue * 10 + Long.parseLong(keyType.getKeyValue());
                if (newAmount > maxValue) {
                    return currentValue;
                }
                return newAmount;
            case KEY_00:
                // press 00
                newAmount = currentValue * 100;
                if (newAmount > maxValue) {
                    return currentValue;
                }
                return newAmount;
            case KEY_BACKSPACE:
                // backpress
                newAmount = currentValue / 10;
                return newAmount;
            case KEY_CLEAR:
                return 0;
        }
        return currentValue;
    }

    // 设置回调
    private AmountKeyBoardCallback callback;

    public void setCallback(AmountKeyBoardCallback callback) {
        this.callback = callback;
    }

    public interface AmountKeyBoardCallback {

        void onKey(KEY_TYPE keyType);

        void onEnable(boolean enable);
    }

}
