package cn.nexgo.inbas.common.widget.creditcarddesign.pager;

import android.os.Bundle;
import android.text.Editable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import cn.nexgo.inbas.R;

import static cn.nexgo.inbas.common.widget.creditcarddesign.CreditCardUtils.EXTRA_CARD_EXPIRY;
import static cn.nexgo.inbas.common.widget.creditcarddesign.CreditCardUtils.EXTRA_VALIDATE_EXPIRY_DATE;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2018/1/28
 * Modify          : create file
 **************************************************************************************************/

public class CardExpiryFragment extends CreditCardFragment {

    private EditText cardExpiryView;

    private boolean mValidateCard = true;

    public CardExpiryFragment() {

    }

    public View onCreateView(LayoutInflater inflater, ViewGroup group, Bundle state) {

        View v = inflater.inflate(R.layout.input_lyt_card_expiry, group, false);
        cardExpiryView = v.findViewById(R.id.card_expiry);

        String expiry = "";

        Bundle args = getArguments();

        if (args != null) {

            if (args.containsKey(EXTRA_CARD_EXPIRY)) {
                expiry = getArguments().getString(EXTRA_CARD_EXPIRY);
            }

            mValidateCard = args.getBoolean(EXTRA_VALIDATE_EXPIRY_DATE, true);
        }

        if (expiry == null) {
            expiry = "";
        }

        cardExpiryView.setText(expiry);

        cardExpiryView.addTextChangedListener(this);

        return v;
    }

    @Override
    public void afterTextChanged(Editable s) {

        String text = s.toString();

        int previousLength = cardExpiryView.getText().length();
        int cursorPosition = cardExpiryView.getSelectionEnd();

        cardExpiryView.removeTextChangedListener(this);
        cardExpiryView.setText(text);
        cardExpiryView.setSelection(text.length());
        cardExpiryView.addTextChangedListener(this);

        int modifiedLength = text.length();

        if (modifiedLength <= previousLength && cursorPosition < modifiedLength) {
            cardExpiryView.setSelection(cursorPosition);
        }

        onEdit(text);
//        if (text.length() == 5) {
//            onComplete();
//        }
    }

    @Override
    public void focus() {

        if (isAdded()) {
            cardExpiryView.selectAll();
        }
    }


    public void onSaveInstanceState(Bundle outState) {

        outState.putBoolean(EXTRA_VALIDATE_EXPIRY_DATE, mValidateCard);
        super.onSaveInstanceState(outState);
    }

    public void onActivityCreated(Bundle instate) {

        if (instate != null) {
            mValidateCard = instate.getBoolean(EXTRA_VALIDATE_EXPIRY_DATE, mValidateCard);
        }

        super.onActivityCreated(instate);
    }

    @Override
    public void edit(String edit) {
        edit = edit.replace("/", "");
        if (edit.length() > 2) {
            edit = edit.substring(0, 2) + "/" + edit.substring(2, edit.length());
        }
        cardExpiryView.setText(edit);
    }
}
