package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.InputFilter;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/29
 * Modify          : create file
 **************************************************************************************************/
public class VerifyPwdDialog extends Dialog {

    private TextView tvTitle;
    private String titleStr;
    private Listener listener;

    private EditText etPwd;
    private TextView tvErrormsg;
    private Button btnOk;
    private ImageView ivCancel;

    public VerifyPwdDialog(Context context) {
        super(context, R.style.add_dialog);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_verifypwd_dialog);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        initView();
        initData();
        initEvent();

        //noinspection ConstantConditions
        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
    }

    /**
     * init back click event
     */
    private void initEvent() {

        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (listener != null) {
                    listener.onConfirm(etPwd.getText().toString());
                }
            }
        });

    }

    private void initData() {

        if (titleStr != null) {
            tvTitle.setText(titleStr);
        }
        setMaxLen(maxLen);
    }

    private void initView() {

        tvTitle = findViewById(R.id.tv_title);
        //add
        etPwd = findViewById(R.id.et_pwd);
        btnOk = findViewById(R.id.btn_ok);
        ivCancel = findViewById(R.id.iv_cancel);
        tvErrormsg = findViewById(R.id.tv_errormsg);
    }

    public void setTitle(String title) {
        titleStr = title;
        if(tvTitle != null){
            tvTitle.setText(title);
        }
    }

    private int maxLen = -1;
    public void setMaxLen(int maxLen){
        this.maxLen = maxLen;
        if(maxLen == -1){
            return;
        }
        if(etPwd == null){
            return;
        }
        InputFilter[] filters = {new InputFilter.LengthFilter(this.maxLen)};
        etPwd.setFilters(filters);
    }

    public String getPwd() {
        return etPwd.getText().toString();
    }

    public void setVerifyRet(boolean ret){
        if(etPwd == null){
            return;
        }
        etPwd.setText("");
        if (ret) {
            tvErrormsg.setVisibility(View.INVISIBLE);
        }else {
            tvErrormsg.setVisibility(View.VISIBLE);
        }
    }

    public void setListener(Listener listener) {

        this.listener = listener;
    }

    public interface Listener {
        void onConfirm(String pwd);
        void onCancel();
    }
}