package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.card.cpu.CPUCardHandler;
import com.nexgo.oaf.apiv3.device.reader.CardReader;
import com.nexgo.oaf.apiv3.device.reader.CardSlotTypeEnum;

import cn.nexgo.inbas.R;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : ruandong
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class SeePhoneDialog extends Dialog {

    private TextView tvCardNo;
    private OnClickListener onClickListener;

    private Button btnOk;
    private ImageView ivCancel;
    private String cardNo;
    private boolean cancel = false;

    public SeePhoneDialog(Context context) {
        super(context, R.style.add_dialog);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_see_phone_dialog);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        initView();
        initEvent();
    }

    /**
     * init back click event
     */
    private void initEvent() {

        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                cancel = true;
                if (onClickListener != null) {
                    onClickListener.onCancel();
                }
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                cancel = true;
                if (onClickListener != null) {
                    onClickListener.onCancel();
                }
            }
        });

        checkContactlessStatue();

    }

    private void checkContactlessStatue(){
        final CardReader cardReader = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCardReader();

        new Thread(new Runnable() {
            @Override
            public void run() {
                while (true){
                    if(cancel){
                        break;
                    }
                    if(!cardReader.isCardExist(CardSlotTypeEnum.RF)){
                        //power off
                        CPUCardHandler cpuCardHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCPUCardHandler(CardSlotTypeEnum.RF);
                        cpuCardHandler.remove();

                        //sleep 1000ms
                        try {
                            Thread.sleep(1000);
                        }
                        catch ( InterruptedException e)
                        {
                            e.printStackTrace();
                        }

                        dismiss();
                        if (onClickListener != null) {
                            onClickListener.onCardRemoved();
                        }
                        break;
                    }
                }
            }
        }).start();
    }


    private void initView() {

        btnOk = findViewById(R.id.btn_cancel);
        ivCancel = findViewById(R.id.iv_cancel);
    }

    public void setOnClickListener(OnClickListener onClicListener) {

        this.onClickListener = onClicListener;
    }

    public interface OnClickListener {
        void onCardRemoved();
        void onCancel();
    }
}