package cn.nexgo.inbas.common.utils;

import com.nexgo.oaf.apiv3.APIProxy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ConvertUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/8
 * Modify          : create file
 **************************************************************************************************/
public class SysTime {
    private static Logger log = LoggerFactory.getLogger(System.class.getSimpleName());

    public static void setSystemTime(String time) {  // MMDDHHMMSS
        String formatedTime = ConvertUtils.formatNumString(time);
        if ((formatedTime == null) || (formatedTime.length() != 10)) {
            log.error("setSystemTime format error->{}", time);
            return;
        }
        // Modify by lee 2018-10-10  add Locale.ENGLISH for Abnormal in multilingual
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy", Locale.ENGLISH);  // get current year
        Date curDate = new Date(System.currentTimeMillis()); // get current date
        String formatedYear = formatter.format(curDate);

        APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).setSystemClock(formatedYear + formatedTime);
    }
}
