package cn.nexgo.inbas.common.utils;

import android.content.Context;
import android.net.ConnectivityManager;

import cn.nexgo.inbas.common.Constans.CardAcq;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/3/8
 * Modify          : create file
 **************************************************************************************************/
public class AppUtils {

    /**
     * getCardAcqByAID
     * @param aid
     * @return
     */
    public static CardAcq getCardAcqByAID(String aid) {
        if (aid == null) {
            return CardAcq.UNKNOWN;
        }
        //AID length must >= 10
        if (aid.length() < 10) {
            return CardAcq.UNKNOWN;

        }
        aid = aid.substring(0, 10);
        if (aid.equalsIgnoreCase("A000000003")) {
            return CardAcq.VISA;
        }
        if (aid.equalsIgnoreCase("A000000004")
                || aid.equalsIgnoreCase("A000000010")) {
            return CardAcq.MASTER;
        }
        if (aid.equalsIgnoreCase("A000000333")) {
            return CardAcq.CUP;
        }
        if (aid.equalsIgnoreCase("A000000065")) {
            return CardAcq.JCB;
        }
        if (aid.equalsIgnoreCase("A000000025")) {
            return CardAcq.AMEX;
        }
        if (aid.equalsIgnoreCase("A000000152")
                || aid.equalsIgnoreCase("A000000324")){
            return CardAcq.DISCOVER;
        }
        return CardAcq.UNKNOWN;
    }

    /**
     * isInternetUseable
     * @return
     */
    public static boolean isInternetUseable(){
        ConnectivityManager manager=(ConnectivityManager) BaseUtils.getApp().getSystemService(Context.CONNECTIVITY_SERVICE);
        if(manager == null){
            return false;
        }
        if (manager.getActiveNetworkInfo()!=null){
            return manager.getActiveNetworkInfo().isAvailable();
        }
        return false;
    }
}
