package cn.nexgo.inbas.common.bean;

import android.os.Parcel;
import android.os.Parcelable;

import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/19
 * Modify          : create file
 **************************************************************************************************/
public class AmountBean implements Parcelable {
    private long longValue = 0;
    private int decimals = 2;
    private int splitLen = 3;
    private String currencySymbol = "$";

    public AmountBean(){

    }

    public AmountBean(long longValue, int decimals, int splitLen, String currencySymbol) {
        this.longValue = longValue;
        this.decimals = decimals;
        this.splitLen = splitLen;
        this.currencySymbol = currencySymbol;
    }

    protected AmountBean(Parcel in) {
        longValue = in.readLong();
        decimals = in.readInt();
        splitLen = in.readInt();
        currencySymbol = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(longValue);
        dest.writeInt(decimals);
        dest.writeInt(splitLen);
        dest.writeString(currencySymbol);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AmountBean> CREATOR = new Creator<AmountBean>() {
        @Override
        public AmountBean createFromParcel(Parcel in) {
            return new AmountBean(in);
        }

        @Override
        public AmountBean[] newArray(int size) {
            return new AmountBean[size];
        }
    };

    @Override
    public String toString() {
        return currencySymbol + "" + FormatUtils.formatAmount(String.valueOf(longValue), splitLen, ",", decimals);
    }

    public long getLongValue() {
        return longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public void setStringValue(String stringValue){
        try {
            Long value = Long.parseLong(stringValue);
            setLongValue(value);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public int getDecimals() {
        return decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

}
