package cn.nexgo.inbas;

import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;

import com.nexgo.common.ByteUtils;
import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.device.pinpad.PinPad;
import com.nexgo.oaf.apiv3.device.pinpad.WorkKeyTypeEnum;
import com.nexgo.oaf.apiv3.emv.AidEntity;
import com.nexgo.oaf.apiv3.emv.CapkEntity;
import com.nexgo.oaf.apiv3.emv.EmvHandler;
import com.nexgo.oaf.apiv3.emv.EmvHandler2;

import java.io.IOException;
import java.util.List;

import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.OperatorEntity;
import cn.nexgo.inbas.components.data.bean.SetupEntity;
import cn.nexgo.inbas.components.data.helper.CardBinHelper;
import cn.nexgo.inbas.components.data.helper.FileUtilsHelper;
import cn.nexgo.inbas.components.emv.EmvUtils;
import cn.nexgo.inbas.transactions.common.protocol.MsgModel;
import cn.nexgo.inbas.transactions.sale.SaleActivity;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ToastUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/8
 * Modify          : create file
 **************************************************************************************************/
public class SplashActivity extends AppCompatActivity {
    private GData gData = GData.getInstance();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.splash_activity);
        Window win = getWindow();  // hide navigate bar
        win.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);
        initAll();
    }

    private void initSettingDB() {
        // init setup data
        SetupEntity setupEntity = DataOpenHelper.getInstance().getSetupRepository().getLast();
        if (setupEntity == null) {
            setupEntity = new SetupEntity();
            DataOpenHelper.getInstance().getSetupRepository().insert(setupEntity);

            for (int i = 1; i <= 5; i++) {  // add init operater
                OperatorEntity operator = new OperatorEntity();
                operator.setOperatorNo("0" + i);
                operator.setPassword("0000");
                DataOpenHelper.getInstance().getOperatorRepository().insert(operator);
            }

        }
        gData.setSetupEntity(setupEntity);

        gData.getMixData().setSN(APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getDeviceInfo().getSn());
        gData.getMixData().setPackageName(getPackageName());
    }

    private void initMsgModel() {
        MsgModel.init();
    }

    private void initAID() {
        EmvHandler2 emvHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getEmvHandler2(gData.getMixData().getPackageName());

        emvHandler.delAllAid();

        // FIXME: 2018/10/11 lee if aid exist, needn't re load
        if (emvHandler.getAidListNum() <= 0) {
            List<AidEntity> aidEntityList = EmvUtils.getAidList();
            if (aidEntityList == null) {
                ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_init_aid_fail));
                return;
            }
            emvHandler.setAidParaList(aidEntityList);

        }
    }

    private void initCAPK() {
        EmvHandler2 emvHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getEmvHandler2(gData.getMixData().getPackageName());
        emvHandler.delAllCapk();
        if (emvHandler.getCapkListNum() <= 0) {
            List<CapkEntity> capkEntityList = EmvUtils.getCapkList();
            if (capkEntityList == null) {
                ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_init_capk_fail));
                return;
            }
            emvHandler.setCAPKList(capkEntityList);

        }
    }

    private void initCardBin() {
        CardBinHelper.init();
    }

    private void initAppDir(){
        String dirPath = Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() + "/";
        FileUtilsHelper fileUtils = new FileUtilsHelper();
        fileUtils.CreateDir(dirPath);

        // FIXME: 2018/8/9 Hassan project can put any file from assets to public dir path
        try {
            fileUtils.assetsFileToDesDir(this, "emvcontactlesscfg.xml", dirPath + "emvcontactlesscfg.xml");
            // FIXME: 2019/3/20 add ssl cer
            fileUtils.assetsFileToDesDir(this, "sslcrt.cer", dirPath + "sslcrt.cer");
            fileUtils.assetsFileToDesDir(this, "nexgo_logo.png", dirPath + "nexgo_logo.png");

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    PinPad pinPad = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getPinPad();

    private void initTestKey(){
        pinPad.writeMKey(gData.getSetupEntity().getSafeTmkIndex(), ByteUtils.hexString2ByteArray("31313131313131313131313131313131"), 16);
        pinPad.writeWKey(gData.getSetupEntity().getSafeTmkIndex(), WorkKeyTypeEnum.MACKEY, ByteUtils.hexString2ByteArray("F92714E80E832EDCF92714E80E832EDC"), 16);
        pinPad.writeWKey(gData.getSetupEntity().getSafeTmkIndex(), WorkKeyTypeEnum.PINKEY, ByteUtils.hexString2ByteArray("F92714E80E832EDCF92714E80E832EDC"), 16);

    }

    private void initAll() {
        Observable.create(new ObservableOnSubscribe<Object>() {
            @Override
            public void subscribe(ObservableEmitter<Object> e) throws Exception {
                initSettingDB();

                initAppDir(); // FIXME: 2018/8/9 Hassan add init dir, for future use


                initAID();
                initCAPK();
                initCardBin();
                initMsgModel();

                // FIXME: 2018/10/15 Hassan remark: usage for demo test
                initTestKey();

                e.onComplete();
            }
        })
                .subscribeOn(Schedulers.newThread())
                .subscribe(new Consumer<Object>() {
                    @Override
                    public void accept(Object o) throws Exception {

                    }
                }, new Consumer<Throwable>() {
                    @Override
                    public void accept(Throwable throwable) throws Exception {

                    }
                }, new Action() {
                    @Override
                    public void run() throws Exception {
//                        Intent intent = new Intent(SplashActivity.this, LogonActivity.class);
                        Intent intent = new Intent(SplashActivity.this, SaleActivity.class);
                        startActivity(intent);
                        finish();
                    }
                });
    }
}
