package cn.nexgo.inbas;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import cn.nexgo.inbas.controller.global.LocaleHelper;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/9
 * Modify          : create file
 **************************************************************************************************/
public class InbasApplication extends Application {
    @Override
    public void onCreate() {
        super.onCreate();

//        if (LeakCanary.isInAnalyzerProcess(this)) {
//            // This process is dedicated to LeakCanary for heap analysis.
//            // You should not init your app in this process.
//            return;
//        }
//        LeakCanary.install(this);
        registerActivityListener();

        initModel();

//        changeLan();
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(LocaleHelper.onAttach(base));
    }

    /**
     * init All Model
     */
    private void initModel() {
        BaseUtils.init(this);
    }

    private List<Activity> activitys = Collections
            .synchronizedList(new LinkedList<Activity>());

    /**
     * activity manager
     */
    private void registerActivityListener() {
        registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                pushActivity(activity);
            }

            @Override
            public void onActivityStarted(Activity activity) {

            }

            @Override
            public void onActivityResumed(Activity activity) {

            }

            @Override
            public void onActivityPaused(Activity activity) {

            }

            @Override
            public void onActivityStopped(Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(Activity activity) {
                if ((null == activitys) || activitys.isEmpty()) {
                    return;
                }
                if (activitys.contains(activity)) {
                    popActivity(activity);
                }
            }
        });
    }

    public void pushActivity(Activity activity) {
        activitys.add(activity);
    }

    public void popActivity(Activity activity) {
        activitys.remove(activity);
    }

    public void finishAllActivity() {
        for (Activity activity : activitys) {
            activity.finish();
        }
        activitys.clear();
    }

    public void changeLan() {
        Resources resources = getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        Configuration config = resources.getConfiguration();
        // 应用用户选择语言
        config.locale = new Locale("fa");//("fa");
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            config.setLayoutDirection(config.locale);
        }
        resources.updateConfiguration(config, dm);
    }
}
