package com.nexgo.apiv3demo;

import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.nexgo.common.ByteUtils;
import com.nexgo.common.LogUtils;
import com.nexgo.oaf.apiv3.DeviceEngine;
import com.nexgo.oaf.apiv3.SdkResult;
import com.nexgo.oaf.apiv3.device.pinpad.AlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.DesAlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.DukptAESGenerateKeyTypeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.DukptAlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.DukptKeyModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.DukptKeyTypeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.MacAlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.OnPinPadInputListener;
import com.nexgo.oaf.apiv3.device.pinpad.PinAlgorithmModeEnum;
import com.nexgo.oaf.apiv3.device.pinpad.PinPad;
import com.nexgo.oaf.apiv3.device.pinpad.PinPadKeyCode;

public class TR31KeyActivity extends AppCompatActivity {

    private DeviceEngine deviceEngine;
    private PinPad pinpad;
    private final int KEYINDEX = 7;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_tr31_key);

        initView();

        initKey();
    }

    // initView
    private TextView log_txt;
    private void initView(){
        log_txt = (TextView) findViewById(R.id.log_txt);
    }


    // init DUKPT
    private void initKey(){
        deviceEngine = ((NexgoApplication) getApplication()).deviceEngine;
        pinpad = deviceEngine.getPinPad();

        pinpad.setAlgorithmMode(AlgorithmModeEnum.DES);
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.tr31_tmk_btn:
                testTr31MK();
                break;

            case R.id.tr31_ipek_btn:
                testTr31Ipek();
                break;


            case R.id.tr31_ipek_aes_btn:
                testTr31IpekAES128();
                break;


        }
    }


    private void testTr31MK(){
        LogUtils.debug("===========testTr31MK==========");

        int ret = -1;
        pinpad.setAlgorithmMode(AlgorithmModeEnum.DES);
        ret = pinpad.injectKBPK(0, ByteUtils.hexString2ByteArray("EFE0853B256B583D868F251CE99EA1D9"), 16);
        LogUtils.debug("testTr31 ret:{}", ret);

        if(ret == SdkResult.Success){
            pinpad.setAlgorithmMode(AlgorithmModeEnum.DES);
            byte[] tr31 = "B0080K0TN00E0000296B219627BF0669066CC557754E73494BE932019756CC4E3B96566DF6BDC692".getBytes();
            byte[] kcv = new byte[3];
            ret = pinpad.injectTr31Key(0, 2, tr31, kcv);

            LogUtils.debug("injectTr31Key ret:{}", ret);
            LogUtils.debug("injectTr31Key kcv:{}", ByteUtils.byteArray2HexString(kcv));

            if(ret == SdkResult.Success){
                log_txt.setText("Inject TR31 TMK block:"+ ret);

                byte[] result = pinpad.encryptByMKey(2, ByteUtils.hexString2ByteArray("0000000000000000"), 8);

                LogUtils.debug("encryptByMKey result:{}", ByteUtils.byteArray2HexString(result));
            }
        }
    }


    private void testTr31Ipek(){
        LogUtils.debug("===========testTr31MK==========");

        int ret = -1;
        pinpad.setAlgorithmMode(AlgorithmModeEnum.DES);
        ret = pinpad.injectKBPK(0, ByteUtils.hexString2ByteArray("0E4BDBFE794A8E585ACE992A5E9AA8CE"), 16);
        LogUtils.debug("testTr31 ret:{}", ret);

        if(ret == SdkResult.Success){
            pinpad.setAlgorithmMode(AlgorithmModeEnum.DUKPT);
            byte[] tr31 = "B0120B1TX00N0200KS14AF128CA0200001E0PB045E117F39D11A9ADF84E09C75E7ACEF05C3C75931D6C10741FC15D8CBFC76EA717EF9C2F2D299C484".getBytes();
            byte[] kcv = new byte[3];
            ret = pinpad.injectTr31Key(0, 1, tr31, kcv);

            LogUtils.debug("injectTr31Key ret:{}", ret);
            LogUtils.debug("injectTr31Key kcv:{}", ByteUtils.byteArray2HexString(kcv));

            if(ret == SdkResult.Success){
                log_txt.setText("Inject TR31 IPEK block:"+ ret);

                byte[] ksn = pinpad.dukptCurrentKsn(1);
                LogUtils.debug("dukptCurrentKsn result:{}", ByteUtils.byteArray2HexString(ksn));

                byte[] result = pinpad.dukptEncrypt(1, DukptKeyModeEnum.REQUEST, ByteUtils.hexString2ByteArray("8080808080808080"), 8,
                        DesAlgorithmModeEnum.CBC, ByteUtils.hexString2ByteArray("0000000000000000"));
                LogUtils.debug("dukptEncrypt result:{}", ByteUtils.byteArray2HexString(result));
            }
        }
    }


    private String KBPK_AES128="0E4BDBFE794A8E585ACE992A5E9AA8CE";
    private String TR31_IPEK_AES128="D0176B1AX00N0200IK14AF128CA0200001E0PB0C2nqbTECm8E8D620798C501E668895B8F3FB57C0BFED6F7F39A2B1B5DE338CEAF06CF6DEA67596BA1193651F22987BF64D6B73897F14DC6C567F97A18A2A99A25603DF1B8";

//    private String KBPK_AES192="0E4BDBFE794A8E585ACE992A5E9AA8CE7ADBEE695B0E68DA";
//    private String TR31_IPEK_AES192="D0176B1AX00N0200IK14AF192CA0200001E0PB0CLhZyIcFrB9B92E410E2FA11C748C7649184A5DC5B297172E7EE396F96AB2975D413CEF69A082A8062B343284AE833D17CADD7D76629A326A75F235D46A30CA4055CC4772";
//
//    private String KBPK_AES256="0E4BDBFE794A8E585ACE992A5E9AA8CE7ADBEE695B0E68DAE0D0A73333220646";
//    private String TR31_IPEK_AES256="D0176B1AX00N0200IK14AF256CA0200001E0PB0CmiCMHFAr8E399A2C587E9827AB50E253D60259AB749FB4ECA66FBDBAB97BC3B616F031A423A7E8CE850769EDC0D646669D8B22906CC11E7D879CED47BC3627F31ABB2997";

    private void testTr31IpekAES128(){
        int ret = -1;
        pinpad.setAlgorithmMode(AlgorithmModeEnum.AES);
        ret = pinpad.injectKBPK(0, ByteUtils.hexString2ByteArray(KBPK_AES128), KBPK_AES128.length()/2);
        LogUtils.debug("injectKBPK ret:{}", ret);

        if(ret == SdkResult.Success){
            pinpad.setAlgorithmMode(AlgorithmModeEnum.DUKPT);
            byte[] tr31 = TR31_IPEK_AES128.getBytes();
            byte[] kcv = new byte[5];
            ret = pinpad.injectTr31Key(0, 1, tr31, kcv);

            LogUtils.debug("injectTr31Key ret:{}", ret);
            LogUtils.debug("injectTr31Key kcv:{}", ByteUtils.byteArray2HexString(kcv));

            if(ret == SdkResult.Success){
                log_txt.setText("Inject TR31 IPEK AES block:"+ ret);

                pinpad.setAlgorithmMode(AlgorithmModeEnum.DUKPT);
                pinpad.setDukptAlgorithmMode(DukptAlgorithmModeEnum.AES);
                pinpad.setDukptAESGenerateKeyType(DukptAESGenerateKeyTypeEnum.DUKPT_MODE_KEY_TYPE_AES128);

                byte[] ksn = pinpad.dukptCurrentKsn(1);
                LogUtils.debug("dukptCurrentKsn result:{}", ByteUtils.byteArray2HexString(ksn));

                byte[] result = pinpad.dukptEncrypt(1, DukptKeyModeEnum.REQUEST, ByteUtils.hexString2ByteArray("0000000000000000"), 8,
                        DesAlgorithmModeEnum.CBC, ByteUtils.hexString2ByteArray("0000000000000000"));
                LogUtils.debug("dukptEncrypt result:{}", ByteUtils.byteArray2HexString(result));
            }
        }
    }




}
